/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.Visitable;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;

public abstract class Directive
implements Macro,
Visitable {
    public static final int ArgType_CONDITION = 1;
    public static final int ArgType_LVALUE = 2;
    public static final int ArgType_RVALUE = 3;
    public static final int ArgType_KEYWORD = 4;
    public static final int ArgType_ASSIGN = 5;
    public static final int ArgType_BLOCK = 6;
    public static final int ArgType_LITBLOCK = 7;
    public static final int ArgType_SUBDIRECTIVE = 8;
    public static final int ArgType_QUOTEDSTRING = 9;
    public static final int ArgType_STRING = 10;
    public static final int ArgType_NAME = 11;
    public static final int ArgType_ARGLIST = 12;
    public static final int ArgType_GROUP = 50;
    public static final int ArgType_CHOICE = 51;

    public abstract Object build(DirectiveBuilder var1, BuildContext var2) throws BuildException;

    public Object evaluate(Context context) throws PropertyException {
        try {
            FastWriter fw = FastWriter.getInstance(context.getBroker());
            this.write(fw, context);
            return fw.toString();
        }
        catch (IOException e) {
            context.getBroker().getLog("engine").error("Directive.evaluate: IO exception on write to StringWriter", e);
            return "";
        }
    }

    protected static String getWarningText(String warning, Context context) throws IOException, PropertyException {
        return context.getEvaluationExceptionHandler().warningString("WARNING: " + warning + " at " + context.getCurrentLocation());
    }

    protected static void writeWarning(String warning, Context context, FastWriter writer) throws IOException, PropertyException {
        context.getLog("directive").warning(warning + " at " + context.getCurrentLocation());
        writer.write(Directive.getWarningText(warning, context));
    }

    public void accept(TemplateVisitor v) {
        v.visitUnknownMacro(this.getClass().getName(), this);
    }

    public static class NotSimpleVariableBuildException
    extends BuildException {
        private static final long serialVersionUID = 1L;

        public NotSimpleVariableBuildException(String directive) {
            super("#" + directive + ": Argument must be a simple variable");
        }

        public NotSimpleVariableBuildException(String directive, Exception e) {
            super("#" + directive + ": Argument must be a simple variable", e);
        }
    }

    public static class NotVariableBuildException
    extends BuildException {
        private static final long serialVersionUID = 1L;

        public NotVariableBuildException(String directive) {
            super("#" + directive + ": Argument must be a variable");
        }

        public NotVariableBuildException(String directive, Exception e) {
            super("#" + directive + ": Argument must be a variable", e);
        }
    }

    public static class OptionalRepeatingSubdirective
    extends OptionalSubdirective {
        public OptionalRepeatingSubdirective(int id, String name, ArgDescriptor[] args) {
            super(id, name, args);
            this.repeating = true;
        }

        public OptionalRepeatingSubdirective(int id, String name, ArgDescriptor[] args, int flags) {
            super(id, name, args, flags);
            this.repeating = true;
        }
    }

    public static class OptionalSubdirective
    extends Subdirective {
        public OptionalSubdirective(int id, String name, ArgDescriptor[] args) {
            super(id, name, args);
            this.setOptional(true);
        }

        public OptionalSubdirective(int id, String name, ArgDescriptor[] args, int flags) {
            super(id, name, args, flags);
            this.setOptional(true);
        }
    }

    public static class Subdirective
    extends ArgDescriptor {
        public static final int BREAKING = 1;
        public final String name;
        public final ArgDescriptor[] args;
        public boolean repeating = false;
        public boolean isBreaking = false;

        public Subdirective(int id, String name, ArgDescriptor[] args) {
            super(id, 8);
            this.name = name;
            this.args = args;
        }

        public Subdirective(int id, String name, ArgDescriptor[] args, int flags) {
            this(id, name, args);
            this.isBreaking = (flags & 1) != 0;
        }
    }

    public static class ExactlyOneChoice
    extends OptionChoice {
        public ExactlyOneChoice(int groupCount) {
            super(groupCount);
            this.setOptional(false);
            this.repeating = false;
        }
    }

    public static class SingleOptionChoice
    extends OptionChoice {
        public SingleOptionChoice(int groupCount) {
            super(groupCount);
            this.repeating = false;
        }
    }

    public static class OptionChoice
    extends ArgDescriptor {
        public boolean repeating = true;

        public OptionChoice(int groupCount) {
            super(0, 51);
            this.setOptional(true);
            this.setSubordinateArgs(groupCount);
        }
    }

    public static class OptionalGroup
    extends ArgDescriptor {
        public OptionalGroup(int argCount) {
            super(0, 50);
            this.setOptional(true);
            this.setSubordinateArgs(argCount);
        }
    }

    public static class FormalArgListArg
    extends ArgDescriptor {
        public FormalArgListArg(int id) {
            super(id, 12);
        }
    }

    public static class NameArg
    extends ArgDescriptor {
        public NameArg(int id) {
            super(id, 11);
        }
    }

    public static class AssignmentArg
    extends ArgDescriptor {
        public AssignmentArg() {
            super(0, 5);
        }
    }

    public static class KeywordArg
    extends ArgDescriptor {
        public KeywordArg(int id, String keyword) {
            super(id, 4);
            this.keyword = keyword;
        }
    }

    public static class StringArg
    extends ArgDescriptor {
        public StringArg(int id) {
            super(id, 10);
        }
    }

    public static class QuotedStringArg
    extends ArgDescriptor {
        public QuotedStringArg(int id) {
            super(id, 9);
        }
    }

    public static class LValueArg
    extends ArgDescriptor {
        public LValueArg(int id) {
            super(id, 2);
        }
    }

    public static class RValueArg
    extends ArgDescriptor {
        public RValueArg(int id) {
            super(id, 3);
        }
    }

    public static class LiteralBlockArg
    extends ArgDescriptor {
        public LiteralBlockArg(int id) {
            super(id, 7);
        }
    }

    public static class BlockArg
    extends ArgDescriptor {
        public BlockArg(int id) {
            super(id, 6);
        }
    }

    public static class ConditionArg
    extends ArgDescriptor {
        public ConditionArg(int id) {
            super(id, 1);
        }
    }

    public static abstract class ArgDescriptor {
        public final int id;
        public final int type;
        public boolean optional = false;
        public int subordinateArgs = 0;
        public int nextArg = 0;
        public int[] children;
        public String keyword;

        protected ArgDescriptor(int id, int type) {
            this.id = id;
            this.type = type;
        }

        protected void setOptional(boolean optional) {
            this.optional = optional;
        }

        protected void setSubordinateArgs(int subordinateArgs) {
            this.subordinateArgs = subordinateArgs;
        }
    }
}

