/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.lang.reflect.Method;
import java.util.Hashtable;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.Provider;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.IntrospectionException;
import org.webmacro.util.Settings;

public final class DirectiveProvider
implements Provider {
    public static final String DIRECTIVE_KEY = "directive";
    private final Hashtable _descriptors = new Hashtable();
    private Log _log;
    private Broker _broker;

    public final void registerDescriptor(DirectiveDescriptor dd, String dirName) {
        this._descriptors.put(dirName, dd);
    }

    public final void registerDirective(String dirClassName, String dirName) throws IntrospectionException, InitException {
        Class directive = null;
        try {
            directive = this._broker.classForName(dirClassName);
        }
        catch (Exception e) {
            throw new IntrospectionException("No class " + dirClassName, e);
        }
        if (Directive.class.isAssignableFrom(directive)) {
            DirectiveDescriptor newDesc;
            DirectiveDescriptor templateDesc;
            try {
                templateDesc = (DirectiveDescriptor)directive.getMethod("getDescriptor", null).invoke(null, (Object[])null);
                newDesc = new DirectiveDescriptor(templateDesc.name, templateDesc.dirClass, templateDesc.args, templateDesc.subdirectives);
                if (newDesc.dirClass == null) {
                    newDesc.dirClass = directive;
                }
            }
            catch (Exception e) {
                throw new IntrospectionException("Class " + dirClassName + " does not have a getDescriptor() method", e);
            }
            Class[] cArg = new Class[]{Broker.class};
            try {
                Method m = directive.getMethod("init", cArg);
                Object[] brokerArg = new Object[]{this._broker};
                try {
                    m.invoke(null, brokerArg);
                }
                catch (Exception e) {
                    this._log.warning("Unable to invoke the init method for the directive " + directive.getName(), e);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            newDesc.name = dirName != null && !dirName.equals("") ? dirName : templateDesc.name;
            DirectiveDescriptor oldDesc = (DirectiveDescriptor)this._descriptors.get(newDesc.name);
            if (oldDesc == null) {
                this._descriptors.put(newDesc.name, newDesc);
                this._log.info("Registered directive: " + newDesc.name);
            } else if (newDesc.dirClass != oldDesc.dirClass) {
                throw new InitException("Attempt to register directive " + directive + " failed because " + oldDesc.dirClass.getName() + " is already registered for type " + newDesc.name);
            }
        }
    }

    private final DirectiveDescriptor getDescriptor(String directiveName) {
        return (DirectiveDescriptor)this._descriptors.get(directiveName);
    }

    public String getType() {
        return DIRECTIVE_KEY;
    }

    public void init(Broker broker, Settings config) throws InitException {
        this._broker = broker;
        this._log = broker.getLog(DIRECTIVE_KEY);
        try {
            config.processListSetting("Directives", new SettingHandler());
        }
        catch (Exception e) {
            this._log.warning("Error initializing DirectiveProvider", e);
            throw new InitException("Could not initialize DirectiveProvider", e);
        }
    }

    public void destroy() {
        this._descriptors.clear();
    }

    public Object get(String name) {
        return this.getDescriptor(name);
    }

    public void flush() {
    }

    private class SettingHandler
    extends Settings.ListSettingHandler {
        private SettingHandler() {
        }

        public void processSetting(String settingKey, String settingValue) {
            try {
                DirectiveProvider.this.registerDirective(settingValue, settingKey);
            }
            catch (Exception ce) {
                DirectiveProvider.this._log.warning("Exception loading directive " + settingValue, ce);
            }
        }
    }
}

