/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import java.util.Iterator;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.Block;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Expression;
import org.webmacro.engine.UndefinedMacro;
import org.webmacro.engine.Variable;

public class ForeachDirective
extends Directive {
    private static final int FOREACH_TARGET = 1;
    private static final int FOREACH_IN_K = 2;
    private static final int FOREACH_LIST = 3;
    private static final int FOREACH_BODY = 4;
    private static final int FOREACH_INDEXING_K = 5;
    private static final int FOREACH_INDEX = 6;
    private static final int FOREACH_LIMIT_K = 7;
    private static final int FOREACH_LIMIT = 8;
    private static final int FOREACH_FROM_K = 9;
    private static final int FOREACH_FROM = 10;
    private static final UndefinedMacro UNDEF = UndefinedMacro.getInstance();
    private Variable target;
    private Variable index;
    private Object list;
    private Object indexFromExpr;
    private Object limitExpr;
    private Macro body;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.LValueArg(1), new Directive.KeywordArg(2, "in"), new Directive.RValueArg(3), new Directive.OptionChoice(2), new Directive.OptionalGroup(3), new Directive.KeywordArg(5, "indexing"), new Directive.LValueArg(6), new Directive.OptionalGroup(2), new Directive.KeywordArg(9, "from"), new Directive.RValueArg(10), new Directive.OptionalGroup(2), new Directive.KeywordArg(7, "limit"), new Directive.RValueArg(8), new Directive.BlockArg(4)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("foreach", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        try {
            this.target = (Variable)builder.getArg(1, bc);
            this.index = (Variable)builder.getArg(6, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(ForeachDirective.myDescr.name, e);
        }
        this.list = builder.getArg(3, bc);
        this.body = (Block)builder.getArg(4, bc);
        this.indexFromExpr = builder.getArg(10, bc);
        this.limitExpr = builder.getArg(8, bc);
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        Iterator iter;
        String warning;
        int loopLimit = -1;
        int loopStart = 1;
        int loopIndex = 0;
        Object l = this.list;
        while (l instanceof Macro && l != UNDEF) {
            l = ((Macro)l).evaluate(context);
        }
        if (this.limitExpr != null) {
            Object limit = this.limitExpr;
            while (limit instanceof Macro && limit != UNDEF) {
                limit = ((Macro)limit).evaluate(context);
            }
            if (Expression.isNumber(limit)) {
                loopLimit = (int)Expression.numberValue(limit);
            } else {
                warning = "#foreach: Cannot evaluate limit";
                ForeachDirective.writeWarning(warning, context, out);
            }
        }
        if (this.index != null && this.indexFromExpr != null) {
            Object from = this.indexFromExpr;
            while (from instanceof Macro && from != UNDEF) {
                from = ((Macro)from).evaluate(context);
            }
            if (Expression.isNumber(from)) {
                loopStart = (int)Expression.numberValue(from);
            } else {
                warning = "#foreach: Cannot evaluate loop start";
                ForeachDirective.writeWarning(warning, context, out);
            }
        }
        try {
            iter = context.getBroker()._propertyOperators.getIterator(l);
        }
        catch (Exception e) {
            String warning2 = "#foreach: ";
            warning2 = this.list instanceof Variable ? warning2 + "$" + ((Variable)this.list).getVariableName() : warning2 + this.list;
            warning2 = warning2 + ": " + e.getMessage();
            ForeachDirective.writeWarning(warning2, context, out);
            return;
        }
        while (iter.hasNext() && (loopLimit == -1 || loopLimit > loopIndex)) {
            try {
                this.target.setValue(context, iter.next());
                if (this.index != null) {
                    this.index.setValue(context, new Integer(loopIndex + loopStart));
                }
            }
            catch (PropertyException e) {
                String errorText = "#foreach: Unable to set list index";
                ForeachDirective.writeWarning(errorText, context, out);
            }
            catch (Exception e) {
                throw new PropertyException("Unable to iterate list", e);
            }
            this.body.write(out, context);
            ++loopIndex;
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(ForeachDirective.myDescr.name);
        v.visitDirectiveArg("ForeachTarget", this.target);
        v.visitDirectiveArg("ForeachList", this.list);
        if (this.index != null) {
            v.visitDirectiveArg("ForeachIndex", this.index);
        }
        if (this.indexFromExpr != null) {
            v.visitDirectiveArg("ForeachFrom", this.indexFromExpr);
        }
        if (this.limitExpr != null) {
            v.visitDirectiveArg("ForeachLimit", this.limitExpr);
        }
        v.visitDirectiveArg("ForeachBlock", this.body);
        v.endDirective();
    }
}

