/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.PropertyException;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.directive.SetDirective;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Variable;

public class ParamDirective
extends Directive {
    private static final int PARAM_TARGET = 1;
    private static final int PARAM_RESULT = 2;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.LValueArg(1), new Directive.AssignmentArg(), new Directive.RValueArg(2)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("param", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        Variable target = null;
        Object result = null;
        try {
            target = (Variable)builder.getArg(1, bc);
            result = builder.getArg(2, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(ParamDirective.myDescr.name, e);
        }
        if (!target.isSimpleName()) {
            throw new Directive.NotSimpleVariableBuildException(ParamDirective.myDescr.name);
        }
        try {
            target.setValue(bc, result);
        }
        catch (PropertyException e) {
            throw new BuildException("#param: Exception setting variable " + target.toString(), e);
        }
        return new SetDirective(target, result);
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
    }
}

