/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Variable;

public class SetDirective
extends Directive {
    private static final int SET_TARGET = 1;
    private static final int SET_RESULT = 2;
    private Variable target;
    private Object result;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.LValueArg(1), new Directive.AssignmentArg(), new Directive.RValueArg(2)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("set", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public SetDirective() {
    }

    public SetDirective(Variable target, Object result) {
        this.target = target;
        this.result = result;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        try {
            this.target = (Variable)builder.getArg(1, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(SetDirective.myDescr.name, e);
        }
        this.result = builder.getArg(2, bc);
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        try {
            if (this.result instanceof Macro) {
                this.target.setValue(context, ((Macro)this.result).evaluate(context));
            } else {
                this.target.setValue(context, this.result);
            }
        }
        catch (PropertyException e) {
            throw e;
        }
        catch (Exception e) {
            String errorText = "#set: Unable to set value: " + this.target;
            SetDirective.writeWarning(errorText, context, out);
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(SetDirective.myDescr.name);
        v.visitDirectiveArg("SetTarget", this.target);
        v.visitDirectiveArg("SetValue", this.result);
        v.endDirective();
    }
}

