/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.UndefinedMacro;
import org.webmacro.engine.Variable;
import org.webmacro.util.Settings;

public class TypeDirective
extends Directive {
    public static final int TYPE_REQUIRED = 0;
    public static final int TYPE_OBJECT = 1;
    public static final int TYPE_CLASSNAME = 2;
    public static final Directive.ArgDescriptor[] _args = new Directive.ArgDescriptor[]{new Directive.OptionalGroup(1), new Directive.KeywordArg(0, "required"), new Directive.RValueArg(1), new Directive.QuotedStringArg(2)};
    public static final DirectiveDescriptor _dd = new DirectiveDescriptor("type", null, _args, null);
    private Variable _object;
    private Class _class;
    private boolean _required;

    public static DirectiveDescriptor getDescriptor() {
        return _dd;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        if (!this.isEnabled(builder.getName(), bc.getBroker())) {
            return null;
        }
        String classname = (String)builder.getArg(2, bc);
        this._object = (Variable)builder.getArg(1, bc);
        this._required = builder.getArg(0, bc) != null;
        try {
            this._class = TypeDirective.getClass(classname);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException("TypeDirective cannot find the class /" + classname + "/");
        }
        return this;
    }

    public Object evaluate(Context context) throws PropertyException {
        Object o = this._object;
        while (o instanceof Macro && o != UndefinedMacro.getInstance()) {
            o = ((Macro)o).evaluate(context);
        }
        if (o == null || o == UndefinedMacro.getInstance()) {
            if (this._required) {
                throw new PropertyException.NoSuchVariableException(this._object.getName());
            }
            return null;
        }
        if (!this._class.isAssignableFrom(o.getClass())) {
            throw new PropertyException.InvalidTypeException(this._object.getName(), this._class);
        }
        return null;
    }

    public void write(FastWriter fw, Context context) throws IOException, PropertyException {
        this.evaluate(context);
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(TypeDirective._dd.name);
        v.visitDirectiveArg("TypeContextObject", this._object);
        v.visitDirectiveArg("TypeClassname", this._class.getName());
        v.endDirective();
    }

    private final boolean isEnabled(String directiveName, Broker broker) {
        Settings s = broker.getSettings();
        return s.getBooleanSetting(directiveName + ".Enabled", true);
    }

    private static final Class getClass(String classname) throws ClassNotFoundException {
        Class<?> clazz;
        if (classname.endsWith("[]")) {
            String newName = "[L" + classname.substring(0, classname.length() - 2);
            if (classname.endsWith("[][]")) {
                newName = "[" + newName.substring(0, newName.length() - 2);
            }
            newName = newName + ";";
            clazz = Class.forName(newName);
        } else {
            clazz = Class.forName(classname);
        }
        return clazz;
    }
}

