/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.Block;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Expression;
import org.webmacro.engine.UndefinedMacro;

class WhileDirective
extends Directive {
    private static final int WHILE_COND = 1;
    private static final int WHILE_LIMIT_K = 2;
    private static final int WHILE_LIMIT = 3;
    private static final int WHILE_BLOCK = 4;
    private Object _obCondition;
    private Macro _macroCondition = null;
    private boolean boolExpression = false;
    private Block _whileBlock;
    private Object _limitExpr;
    private static final UndefinedMacro UNDEF = UndefinedMacro.getInstance();
    private static final Directive.ArgDescriptor[] ifArgs = new Directive.ArgDescriptor[]{new Directive.ConditionArg(1), new Directive.OptionalGroup(2), new Directive.KeywordArg(2, "limit"), new Directive.RValueArg(3), new Directive.BlockArg(4)};
    private static final DirectiveDescriptor _desc = new DirectiveDescriptor("while", null, ifArgs, null);
    protected String _directiveName;

    WhileDirective() {
    }

    public static DirectiveDescriptor getDescriptor() {
        return _desc;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        this._directiveName = builder.getName();
        this._obCondition = builder.getArg(1, bc);
        if (this._obCondition instanceof Macro) {
            this._macroCondition = (Macro)this._obCondition;
        } else if (this._obCondition instanceof Boolean) {
            this.boolExpression = Expression.isTrue(this._obCondition);
        } else {
            throw new BuildException("#" + this._directiveName + ": does not provide a valid condition!");
        }
        this._limitExpr = builder.getArg(3, bc);
        this._whileBlock = (Block)builder.getArg(4, bc);
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        String warning;
        int loopLimit = 1000000;
        int loopIndex = 0;
        if (this._limitExpr != null) {
            Object limit = this._limitExpr;
            while (limit instanceof Macro && limit != UNDEF) {
                limit = ((Macro)limit).evaluate(context);
            }
            if (Expression.isNumber(limit)) {
                loopLimit = (int)Expression.numberValue(limit);
            } else {
                warning = "#" + this._directiveName + ": Cannot evaluate limit";
                WhileDirective.writeWarning(warning, context, out);
            }
        }
        if (this._macroCondition != null) {
            this.boolExpression = Expression.isTrue(this._macroCondition.evaluate(context));
        }
        while (this.boolExpression && (loopLimit < 0 || loopIndex < loopLimit)) {
            this._whileBlock.write(out, context);
            if (this._macroCondition != null) {
                this.boolExpression = Expression.isTrue(this._macroCondition.evaluate(context));
            }
            ++loopIndex;
        }
        if (loopIndex >= loopLimit) {
            warning = "#" + this._directiveName + ": exeeded the limit of " + loopLimit;
            WhileDirective.writeWarning(warning, context, out);
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(WhileDirective._desc.name);
        v.visitDirectiveArg("WhileCondition", this._macroCondition);
        v.visitDirectiveArg("WhileBlock", this._whileBlock);
        if (this._limitExpr != null) {
            v.visitDirectiveArg("WhileLimit", this._limitExpr);
        }
        v.endDirective();
    }
}

