/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.Log;
import org.webmacro.PropertyException;
import org.webmacro.engine.EvaluationExceptionHandler;
import org.webmacro.engine.Variable;
import org.webmacro.util.Settings;

public class DefaultEvaluationExceptionHandler
implements EvaluationExceptionHandler {
    private Log _log;

    public DefaultEvaluationExceptionHandler() {
    }

    public DefaultEvaluationExceptionHandler(Broker b) {
        this.init(b, b.getSettings());
    }

    public void init(Broker b, Settings config) {
        this._log = b.getLog("engine");
    }

    public void evaluate(Variable variable, Context context, Exception problem) throws PropertyException {
        if (problem instanceof PropertyException) {
            ((PropertyException)problem).setContextLocation(context.getCurrentLocation());
        } else {
            problem = new PropertyException("Error evaluating $" + variable.getVariableName(), problem, context.getCurrentLocation());
        }
        if (this._log != null) {
            this._log.error(problem.getMessage());
        }
        if (problem instanceof PropertyException.NoSuchVariableException || problem instanceof PropertyException.NullValueException || problem instanceof PropertyException.NullToStringException) {
            return;
        }
        throw (PropertyException)problem;
    }

    public String expand(Variable variable, Context context, Exception problem) throws PropertyException {
        if (problem instanceof PropertyException) {
            ((PropertyException)problem).setContextLocation(context.getCurrentLocation());
        } else {
            problem = new PropertyException("Error expanding $" + variable.getVariableName(), problem, context.getCurrentLocation());
        }
        if (this._log != null) {
            this._log.error(problem.getMessage());
        }
        if (problem instanceof PropertyException.NoSuchVariableException || problem instanceof PropertyException.UndefinedVariableException || problem instanceof PropertyException.NullValueException || problem instanceof PropertyException.NullToStringException) {
            return this.errorString(problem.getMessage());
        }
        throw (PropertyException)problem;
    }

    public String warningString(String warningText) {
        return "<!-- " + warningText + " -->";
    }

    public String errorString(String errorText) {
        return "<!-- " + errorText + " -->";
    }
}

