/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.util.HashMap;
import java.util.Map;
import org.webmacro.PropertyException;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.MacroDefinition;

public class MacroBuildContext
extends BuildContext {
    private BuildContext chainedContext;
    private BuildContext rootContext;
    private MacroDefinition macro;
    private Object[] args;
    private Map macroArgs = new HashMap();

    public MacroBuildContext(MacroDefinition macroP, Object[] argsP, BuildContext bc) {
        super(bc.getBroker());
        this.chainedContext = bc;
        this.args = argsP;
        this.macro = macroP;
        String[] argNames = this.macro.getArgNames();
        for (int i = 0; i < argNames.length; ++i) {
            this.macroArgs.put(argNames[i], this.args[i]);
        }
        this.rootContext = this.chainedContext;
        while (this.rootContext instanceof MacroBuildContext) {
            this.rootContext = ((MacroBuildContext)this.rootContext).chainedContext;
        }
    }

    public BuildContext getRootContext() {
        return this.rootContext;
    }

    public void putMacro(String name, MacroDefinition macro) {
        this.rootContext.putMacro(name, macro);
    }

    public MacroDefinition getMacro(String name) {
        return this.rootContext.getMacro(name);
    }

    public boolean containsKey(Object name) {
        return this.macroArgs.containsKey(name) || this.chainedContext.containsKey(name);
    }

    protected Object internalGet(Object name) throws PropertyException {
        if (this.macroArgs.containsKey(name)) {
            return this.macroArgs.get(name);
        }
        return this.rootContext.get(name);
    }
}

