/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.lang.reflect.Method;
import org.webmacro.PropertyException;
import org.webmacro.engine.Accessor;
import org.webmacro.engine.PropertyOperator;

abstract class MethodAccessor
extends Accessor {
    protected Method _getMethod;
    private Method[] _setMethods = null;
    private Class[] _setParams = null;
    private Class[] _setPrimitiveType = null;
    private int setCount = 0;

    abstract int numArgsGet();

    abstract int numArgsSet();

    MethodAccessor(String name, Method m, Class[] params) throws PropertyException {
        super(name);
        this.addMethod(m, params);
    }

    private Class getWrapperClass(Class s) {
        if (s == Integer.TYPE) {
            return Integer.class;
        }
        if (s == Boolean.TYPE) {
            return Boolean.class;
        }
        if (s == Character.TYPE) {
            return Character.class;
        }
        if (s == Long.TYPE) {
            return Long.class;
        }
        if (s == Short.TYPE) {
            return Short.class;
        }
        if (s == Double.TYPE) {
            return Double.class;
        }
        if (s == Float.TYPE) {
            return Float.class;
        }
        if (s == Void.TYPE) {
            return Void.class;
        }
        if (s == Byte.TYPE) {
            return Byte.class;
        }
        return null;
    }

    final void addMethod(Method m, Class[] params) throws PropertyException {
        int setArgsLength = this.numArgsSet();
        int getArgsLength = this.numArgsGet();
        if (params.length == getArgsLength) {
            this._getMethod = m;
        } else if (params.length == setArgsLength) {
            ++this.setCount;
            if (this._setMethods == null) {
                this._setMethods = new Method[1];
                this._setParams = new Class[1];
                this._setPrimitiveType = new Class[1];
            } else if (this._setMethods.length <= this.setCount) {
                Method[] tmpMethods = new Method[(this.setCount + 1) * 2];
                Class[] tmpParams = new Class[(this.setCount + 1) * 2];
                Class[] tmpPrimitive = new Class[(this.setCount + 1) * 2];
                System.arraycopy(this._setMethods, 0, tmpMethods, 0, this._setMethods.length);
                System.arraycopy(this._setParams, 0, tmpParams, 0, this._setParams.length);
                System.arraycopy(this._setPrimitiveType, 0, tmpPrimitive, 0, this._setParams.length);
                this._setMethods = tmpMethods;
                this._setParams = tmpParams;
                this._setPrimitiveType = tmpPrimitive;
            }
            this._setMethods[this.setCount - 1] = m;
            this._setParams[this.setCount - 1] = params[setArgsLength - 1];
            if (this._setParams[this.setCount - 1].isPrimitive()) {
                this._setPrimitiveType[this.setCount - 1] = this.getWrapperClass(this._setParams[this.setCount - 1]);
            }
        } else {
            throw new PropertyException("PropertyOperator FAILED for method " + m + "--please report this bug!");
        }
    }

    final boolean setImpl(Object inst, Object[] args) throws PropertyException, NoSuchMethodException {
        for (int i = 0; i < this.setCount; ++i) {
            Object arg = args[args.length - 1];
            if (this._setParams[i].isPrimitive()) {
                if (arg.getClass() != this._setPrimitiveType[i]) continue;
                try {
                    PropertyOperator.invoke(this._setMethods[i], inst, args);
                    return true;
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (arg != null && !this._setParams[i].isInstance(args[args.length - 1])) continue;
            PropertyOperator.invoke(this._setMethods[i], inst, args);
            return true;
        }
        return false;
    }
}

