/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.webmacro.PropertyException;
import org.webmacro.engine.IntrospectionUtils;
import org.webmacro.engine.VoidMacro;

public class MethodWrapper {
    private Object _instance;
    private Class _class;
    private Method[] _methods;

    public MethodWrapper(Object o, String methodName) {
        if (o instanceof Class) {
            this._instance = null;
            this._class = (Class)o;
        } else {
            this._instance = o;
            this._class = this._instance.getClass();
        }
        Method[] mArr = this._class.getMethods();
        ArrayList<Method> mList = new ArrayList<Method>(mArr.length);
        int methCnt = 0;
        for (int i = 0; i < mArr.length; ++i) {
            if (!mArr[i].getName().equals(methodName)) continue;
            ++methCnt;
            if (this._instance == null) {
                int mod = mArr[i].getModifiers();
                if (!Modifier.isStatic(mod)) continue;
                mList.add(mArr[i]);
                continue;
            }
            mList.add(mArr[i]);
        }
        if (mList.size() == 0) {
            if (methCnt == 0) {
                throw new IllegalArgumentException("No such method as " + methodName + " in class " + this._class.getName() + "!");
            }
            throw new IllegalStateException("Cannot invoke non-static method " + methodName + " without an instance of the class " + this._class.getName() + "!");
        }
        this._methods = new Method[mList.size()];
        mList.toArray(this._methods);
    }

    public Object invoke(Object[] args) throws PropertyException {
        Class[] types = IntrospectionUtils.createTypesFromArgs(args);
        for (int i = 0; i < this._methods.length; ++i) {
            Method m = this._methods[i];
            Class[] sig = m.getParameterTypes();
            if (!IntrospectionUtils.matches(sig, types)) continue;
            try {
                Object obj = m.invoke(this._instance, args);
                if (obj == null && m.getReturnType() == Void.TYPE) {
                    return VoidMacro.instance;
                }
                return obj;
            }
            catch (Exception e) {
                String argList = Arrays.asList(args).toString();
                String errMsg = "Unable to execute " + this.getDescription() + " on supplied args: " + argList;
                throw new PropertyException(errMsg, e);
            }
        }
        String argList = Arrays.asList(args).toString();
        String errMsg = "Unable to execute " + this.getDescription() + " on supplied args: " + argList;
        throw new PropertyException(errMsg);
    }

    public String getDescription() {
        String methName = this._methods[0].getName();
        String className = this._methods[0].getDeclaringClass().getName();
        return className + "." + methName + "()]";
    }
}

