/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.WM;
import org.webmacro.engine.TestObject;
import org.webmacro.engine.WMTemplate;
import org.webmacro.util.SelectList;

public class StreamTemplate
extends WMTemplate {
    private Reader _in;
    private String _name = null;

    public StreamTemplate(Broker broker, Reader inStream) {
        super(broker);
        this._in = inStream;
    }

    public StreamTemplate(Broker broker, InputStream in) throws IOException {
        this(broker, in, null);
    }

    public StreamTemplate(Broker broker, InputStream in, String encoding) throws IOException {
        super(broker);
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        this._in = new InputStreamReader(in, encoding);
    }

    protected Reader getReader() throws IOException {
        if (this._in != null) {
            Reader ret = this._in;
            this._in = null;
            return ret;
        }
        throw new IOException("Already read stream.");
    }

    public String toString() {
        String s = null;
        if (this._in != null) {
            s = this._in.toString();
        }
        return this._name != null ? "StreamTemplate:" + this._name : (s != null ? "StreamTemplate(" + this._in + ")" : "(stream)");
    }

    public String getName() {
        return this._name == null ? this.toString() : this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public static void main(String[] arg) {
        WM wm = null;
        Context context = null;
        String encoding = null;
        try {
            wm = new WM();
            context = wm.getContext();
            Object[] names = new Object[]{"prop"};
            context.setProperty(names, (Object)"Example property");
            encoding = wm.getConfig("TemplateEncoding");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            context.put((Object)"helloworld", "Hello World");
            context.put((Object)"hello", "Hello");
            context.put((Object)"file", "include.txt");
            context.put((Object)"today", new Date());
            Object[] fruits = new TestObject[]{new TestObject("apple", false), new TestObject("lemon", true), new TestObject("pear", false), new TestObject("orange", true), new TestObject("watermelon", false), new TestObject("peach", false), new TestObject("lime", true)};
            SelectList sl = new SelectList(fruits, 3);
            context.put((Object)"sl-fruits", sl);
            context.put((Object)"fruits", fruits);
            context.put((Object)"flipper", new TestObject("flip", false));
            System.out.println("- - - - - - - - - - - - - - - - - - - -");
            System.out.println("Context contains: helloWorld, hello, file, TestObject[] fruits, SelectList sl(fruits, 3), TestObject flipper");
            System.out.println("- - - - - - - - - - - - - - - - - - - -");
            StreamTemplate t1 = new StreamTemplate(wm.getBroker(), new InputStreamReader(System.in));
            t1.parse();
            System.out.println("*** RESULT ***");
            t1.write(System.out, encoding, context);
            System.out.println("*** DONE ***");
            context.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

