/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.Visitable;
import org.webmacro.util.Named;

public abstract class Variable
implements Macro,
Visitable {
    public static final Object PROPERTY_TYPE = new Object();
    public static final Object LOCAL_TYPE = new Object();
    private String _vname;
    protected Object[] _names;

    Variable(Object[] names) {
        this._names = names;
    }

    static final String[] makePropertyNames(Object[] names) {
        String[] sn = new String[names.length];
        for (int i = 0; i < sn.length; ++i) {
            sn[i] = names[i] instanceof Named ? ((Named)names[i]).getName() : (String)names[i];
        }
        return sn;
    }

    public final String[] getPropertyNames() {
        return Variable.makePropertyNames(this._names);
    }

    public final String getName() {
        return this._names[0] instanceof Named ? ((Named)this._names[0]).getName() : (String)this._names[0];
    }

    public boolean isSimpleName() {
        return this._names.length == 1;
    }

    public final Object evaluate(Context context) throws PropertyException {
        try {
            Object val = this.getValue(context);
            if (val instanceof Macro) {
                val = ((Macro)val).evaluate(context);
            }
            return val;
        }
        catch (NullPointerException e) {
            context.getEvaluationExceptionHandler().evaluate(this, context, new PropertyException.NullValueException(this.getVariableName()));
            return null;
        }
        catch (PropertyException e) {
            if (e instanceof PropertyException.UndefinedVariableException) {
                PropertyException.UndefinedVariableException uve = (PropertyException.UndefinedVariableException)e;
                if (this._names.length > 1) {
                    uve.setMessage("Attempted to reference a property or method of an undefined variable: $" + this._names[0]);
                } else {
                    uve.setMessage("Attempted to evaluate an undefined variable: $" + this._names[0]);
                }
            }
            context.getEvaluationExceptionHandler().evaluate(this, context, e);
            return null;
        }
        catch (Exception e) {
            context.getEvaluationExceptionHandler().evaluate(this, context, new PropertyException("Variable: exception evaluating " + this.getVariableName(), e));
            return null;
        }
    }

    public final void write(FastWriter out, Context context) throws PropertyException, IOException {
        try {
            Object val = this.getValue(context);
            if (val instanceof Macro) {
                ((Macro)val).write(out, context);
            } else if (val != null) {
                String v = val.toString();
                if (v != null) {
                    out.write(v);
                } else {
                    out.write(context.getEvaluationExceptionHandler().expand(this, context, new PropertyException.NullToStringException(this.getVariableName())));
                }
            } else if (this.isSimpleName()) {
                out.write(context.getEvaluationExceptionHandler().expand(this, context, new PropertyException.NoSuchVariableException(this.getVariableName())));
            } else {
                out.write(context.getEvaluationExceptionHandler().expand(this, context, new PropertyException.NullValueException(this.getVariableName())));
            }
        }
        catch (PropertyException e) {
            if (e instanceof PropertyException.UndefinedVariableException) {
                PropertyException.UndefinedVariableException uve = (PropertyException.UndefinedVariableException)e;
                if (this._names.length > 1) {
                    uve.setMessage("Attempted to write a property or method value of an undefined variable: $" + this._names[0]);
                } else {
                    uve.setMessage("Attempted to write an undefined variable: $" + this._names[0]);
                }
            }
            out.write(context.getEvaluationExceptionHandler().expand(this, context, e));
        }
        catch (Exception e) {
            out.write(context.getEvaluationExceptionHandler().expand(this, context, e));
        }
    }

    static final String makeName(Object[] names) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            if (i != 0) {
                buf.append(".");
            }
            buf.append(names[i]);
        }
        return buf.toString();
    }

    public abstract Object getValue(Context var1) throws PropertyException;

    public abstract void setValue(Context var1, Object var2) throws PropertyException;

    public abstract String toString();

    public synchronized String getVariableName() {
        if (this._vname == null) {
            this._vname = Variable.makeName(this._names).intern();
        }
        return this._vname;
    }

    public void accept(TemplateVisitor v) {
        v.visitVariable(this, this._names);
    }
}

