/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Log;
import org.webmacro.PropertyException;
import org.webmacro.Template;
import org.webmacro.TemplateException;
import org.webmacro.TemplateVisitor;
import org.webmacro.engine.Block;
import org.webmacro.engine.BlockBuilder;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.MacroDefinition;
import org.webmacro.engine.Parser;

public abstract class WMTemplate
implements Template {
    protected final Broker _broker;
    protected final Log _log;
    private boolean _parsed;
    protected Block _content;
    private String _parserName;
    private Map _parameters;
    private Map _macros;

    protected WMTemplate(Broker broker) {
        this("wm", broker);
    }

    protected WMTemplate(String parserName, Broker broker) {
        this._broker = broker;
        this._parserName = parserName;
        this._log = broker.getLog("template", "template lifecycle");
    }

    protected abstract Reader getReader() throws IOException;

    public abstract String toString();

    public String getName() {
        return this.toString();
    }

    public void setName(String name) {
    }

    protected Parser getParser() throws TemplateException {
        try {
            return (Parser)this._broker.get("parser", "wm");
        }
        catch (Exception e) {
            throw new TemplateException("Could not load parser type " + this._parserName, e);
        }
    }

    public void parse() throws IOException, TemplateException {
        if (!this._parsed) {
            Block newContent = null;
            Map newParameters = null;
            Map newMacros = null;
            Reader in = null;
            Context bc = null;
            try {
                Parser parser = this.getParser();
                in = this.getReader();
                BlockBuilder bb = parser.parseBlock(this.getName(), in);
                in.close();
                bc = new BuildContext(this._broker);
                Map globalMacros = this._broker.getMacros();
                Iterator i = globalMacros.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    ((BuildContext)bc).putMacro((String)entry.getKey(), (MacroDefinition)entry.getValue());
                }
                newParameters = bc.getMap();
                newMacros = ((BuildContext)bc).getMacros();
                newContent = (Block)bb.build((BuildContext)bc);
            }
            catch (BuildException be) {
                if (bc != null) {
                    be.setContextLocation(bc.getCurrentLocation());
                }
                this._log.error("Template contained invalid data", be);
                throw be;
            }
            catch (IOException e) {
                this._log.error("Template: Could not read template: " + this);
                throw e;
            }
            catch (Exception e) {
                this._log.error("Error parsing template: " + this, e);
                BuildException be = new BuildException("Error parsing template: " + this, e);
                if (bc != null) {
                    be.setContextLocation(bc.getCurrentLocation());
                }
                throw be;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    Object e2 = null;
                }
                this._parameters = newParameters;
                this._content = newContent;
                this._macros = newMacros;
                this._parsed = true;
            }
        }
        this._log.debug("Ignoring parse request on already parsed template " + this);
    }

    public Map getMacros() {
        return this._macros;
    }

    public final String evaluateAsString(Context context) throws PropertyException {
        try {
            FastWriter fw = FastWriter.getInstance(this._broker);
            this.write(fw, context);
            String ret = fw.toString();
            fw.close();
            return ret;
        }
        catch (IOException e) {
            this._log.error("Template: Could not write to ByteArrayOutputStream!", e);
            return null;
        }
    }

    public final byte[] evaluateAsBytes(String encoding, Context context) throws PropertyException {
        try {
            FastWriter fw = FastWriter.getInstance(this._broker, encoding);
            this.write(fw, context);
            byte[] ret = fw.toByteArray();
            fw.close();
            return ret;
        }
        catch (IOException e) {
            this._log.error("Template: Could not write to ByteArrayOutputStream!", e);
            return null;
        }
    }

    public void write(OutputStream out, Context context) throws PropertyException, IOException {
        FastWriter fw = FastWriter.getInstance(this._broker, out);
        this.write(fw, context);
        fw.flush();
        fw.close();
    }

    public void write(OutputStream out, String encoding, Context context) throws PropertyException, IOException {
        FastWriter fw = FastWriter.getInstance(this._broker, out, encoding);
        this.write(fw, context);
        fw.flush();
        fw.close();
    }

    public final void write(FastWriter out, Context context) throws IOException, PropertyException {
        try {
            if (!this._parsed) {
                this.parse();
            }
        }
        catch (TemplateException e) {
            this._log.error("Template: Unable to parse template: " + this, e);
            out.write(context.getEvaluationExceptionHandler().errorString("Template failed to parse. Reason: \n" + e.toString()));
        }
        try {
            this._content.write(out, context);
        }
        catch (PropertyException e) {
            e.setContextLocation(context.getCurrentLocation());
            throw e;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            String warning = "Template: Exception evaluating template " + this;
            this._log.warning(warning, e);
            out.write(context.getEvaluationExceptionHandler().warningString("Could not interpret template. Reason: \n" + warning + "\n" + e.toString()));
        }
    }

    public void accept(TemplateVisitor v) {
        this._content.accept(v);
    }

    protected final String getDefaultEncoding() {
        try {
            return (String)this._broker.get("config", "TemplateEncoding");
        }
        catch (Exception e) {
            return System.getProperty("file.encoding");
        }
    }

    public Object getParam(String key) throws IOException, TemplateException {
        try {
            return this._parameters.get(key);
        }
        catch (NullPointerException e) {
            this.parse();
            return this._parameters.get(key);
        }
    }

    public Map getParameters() {
        return this._parameters;
    }

    public void setParam(String key, Object value) {
        this._parameters.put(key, value);
    }
}

