/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.net.URL;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.resource.AbstractTemplateLoader;
import org.webmacro.resource.CacheElement;
import org.webmacro.util.Settings;

public class ClassPathTemplateLoader
extends AbstractTemplateLoader {
    private ClassLoader loader;
    private String path;

    public void init(Broker broker, Settings config) throws InitException {
        super.init(broker, config);
        this.loader = broker.getClassLoader();
    }

    public void setConfig(String config) {
        if (config.length() > 0 && !config.endsWith("/")) {
            if (this.log.loggingInfo()) {
                this.log.info("ClassPathTemplateLoader: appending \"/\" to path " + config);
            }
            config = config.concat("/");
        }
        if (config.startsWith("/")) {
            config = config.substring(1);
        }
        this.path = config;
    }

    public Template load(String query, CacheElement ce) throws ResourceException {
        URL url;
        if (query.startsWith("/")) {
            query = query.substring(1);
        }
        if ((url = this.loader.getResource(this.path.concat(query))) != null && this.log.loggingDebug()) {
            this.log.debug("ClassPathTemplateProvider: Found Template " + url.toString());
        }
        return url != null ? this.helper.load(url, ce) : null;
    }
}

