/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.TemplateException;
import org.webmacro.engine.FileTemplate;
import org.webmacro.engine.StreamTemplate;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CacheReloadContext;
import org.webmacro.resource.InvalidResourceException;
import org.webmacro.resource.ReloadDelayDecorator;
import org.webmacro.resource.UrlProvider;
import org.webmacro.util.Settings;

public class TemplateLoaderHelper {
    private Broker broker;
    private ReloadDelayDecorator reloadDelay;

    public void init(Broker b, Settings config) throws InitException {
        this.broker = b;
        this.reloadDelay = new ReloadDelayDecorator();
        this.reloadDelay.init(b, config);
    }

    public Template load(File file, CacheElement ce) throws ResourceException {
        FileTemplate t = new FileTemplate(this.broker, file);
        this.parseTemplate(t);
        if (ce != null) {
            FTReloadContext reloadContext = new FTReloadContext(file, file.lastModified());
            ce.setReloadContext(this.reloadDelay.decorate("file", reloadContext));
        }
        return t;
    }

    public Template load(URL url, CacheElement ce) throws ResourceException {
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            return this.load(file, ce);
        }
        try {
            URLConnection conn = url.openConnection();
            long lastMod = conn.getLastModified();
            String encoding = conn.getContentEncoding();
            StreamTemplate t = new StreamTemplate(this.broker, conn.getInputStream(), encoding);
            t.setName(url.toExternalForm());
            this.parseTemplate(t);
            if (ce != null) {
                UrlReloadContext reloadContext = new UrlReloadContext(url, lastMod);
                ce.setReloadContext(this.reloadDelay.decorate(url.getProtocol(), reloadContext));
            }
            return t;
        }
        catch (IOException e) {
            throw new InvalidResourceException("IOException while reading template from " + url, e);
        }
    }

    private void parseTemplate(Template template) throws ResourceException {
        try {
            template.parse();
        }
        catch (IOException e) {
            throw new InvalidResourceException("IOException while reading template " + template.getName(), e);
        }
        catch (TemplateException e) {
            throw new InvalidResourceException("Error while parsing template: " + template.getName(), e);
        }
    }

    private static class UrlReloadContext
    extends CacheReloadContext {
        private long lastModified;
        private URL url;

        public UrlReloadContext(URL url, long lastModified) {
            this.url = url;
            this.lastModified = lastModified;
        }

        public boolean shouldReload() {
            return this.lastModified != UrlProvider.getUrlLastModified(this.url);
        }
    }

    private static class FTReloadContext
    extends CacheReloadContext {
        private File file;
        private long lastModified;

        public FTReloadContext(File f, long lastModified) {
            this.file = f;
            this.lastModified = lastModified;
        }

        public boolean shouldReload() {
            return this.lastModified != this.file.lastModified();
        }
    }
}

