/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.File;
import java.util.StringTokenizer;
import org.webmacro.InitException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.resource.AbstractTemplateLoader;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.FileTemplateLoader;
import org.webmacro.resource.TemplateLoader;
import org.webmacro.util.Settings;

public class TemplatePathTemplateLoader
extends AbstractTemplateLoader {
    private TemplateLoader[] loaders;

    public void setConfig(String config) throws InitException {
        Settings settings = this.broker.getSettings();
        String templatePath = settings.getSetting("TemplatePath", "");
        this.log.info("Using legacy template path " + templatePath);
        if (templatePath.length() != 0) {
            StringTokenizer st = new StringTokenizer(templatePath, File.pathSeparator);
            this.loaders = new TemplateLoader[st.countTokens()];
            for (int i = 0; i < this.loaders.length; ++i) {
                FileTemplateLoader loader = new FileTemplateLoader();
                loader.init(this.broker, settings);
                loader.setConfig(st.nextToken());
                this.loaders[i] = loader;
            }
        }
    }

    public final Template load(String query, CacheElement ce) throws ResourceException {
        if (this.loaders != null) {
            for (int i = 0; i < this.loaders.length; ++i) {
                Template t = this.loaders[i].load(query, ce);
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }
}

