/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.NotFoundException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CachingProvider;
import org.webmacro.resource.URLTemplate;
import org.webmacro.util.Settings;

public final class URLTemplateProvider
extends CachingProvider {
    public static final String RCS = "@(#) $Id: URLTemplateProvider.java,v 1.21 2008/03/25 22:54:09 timp Exp $";
    private Broker _broker = null;
    private static String _pathSeparator = ";";
    private String[] _templateDirectory = null;
    private static final String _OPEN = "{";
    private static final String _CLOSE = "}";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String CONTEXT_PREFIX = "context:";
    private static final String IGNORE_PREFIX = "ignore:";
    private static final int CLASSPATH_PREFIX_LENGTH = "classpath:".length();
    private static final String _TYPE = "template";
    private URL _baseURL = null;
    private final HashMap templateNameCache = new HashMap();
    private String _templatePath;
    private Log _log;
    private static final String _SEP = "/";

    public final String getType() {
        return _TYPE;
    }

    public void init(Broker b, Settings config) throws InitException {
        super.init(b, config);
        this._broker = b;
        this._log = b.getLog("resource", "general object loading");
        try {
            this._templatePath = config.getSetting("TemplatePath");
            StringTokenizer st = new StringTokenizer(this._templatePath, _pathSeparator);
            this._templateDirectory = new String[st.countTokens()];
            for (int i = 0; i < this._templateDirectory.length; ++i) {
                String dir;
                this._templateDirectory[i] = dir = st.nextToken();
            }
        }
        catch (Exception e) {
            throw new InitException("Could not initialize", e);
        }
    }

    public final Object load(String name, CacheElement ce) throws ResourceException {
        return this.load(name, this._baseURL);
    }

    public final Object load(String name, URL base) throws ResourceException {
        this._log.debug("Load URLTemplate: (" + base + "," + name + ")");
        try {
            Template _tmpl = null;
            _tmpl = base == null ? this.getTemplate(name) : this.getTemplate(new URL(base, name));
            if (_tmpl == null) {
                throw new NotFoundException(this + " could not locate " + name + " on path " + this._templatePath);
            }
            this.templateNameCache.put(name, _tmpl);
            return _tmpl;
        }
        catch (IOException e) {
            this._log.debug(e.getClass().getName() + " " + e.getMessage());
            throw new ResourceException(e.getMessage());
        }
    }

    public final boolean shouldReload(String name) {
        URLTemplate tmpl = (URLTemplate)this.templateNameCache.get(name);
        return tmpl == null ? false : tmpl.shouldReload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean exists(URL url) {
        InputStream _is = null;
        try {
            _is = url.openStream();
            System.out.println(url + " exists");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.out.println(url + " does not exist");
            boolean bl = false;
            return bl;
        }
        finally {
            if (_is != null) {
                try {
                    _is.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private final Template getTemplate(URL path) {
        this._log.debug("get:" + path);
        String pre = null;
        String mid = null;
        String post = null;
        String pathStr = path.toExternalForm();
        try {
            String[] parts = this.parseLocalePath(pathStr);
            String urlPath = null;
            URL url = path;
            if (parts == null) {
                urlPath = pathStr;
            } else {
                pre = parts[0];
                mid = parts[1];
                post = parts[2];
                urlPath = pre + (mid == null ? "" : mid) + post;
                url = new URL(urlPath);
            }
            if (urlPath.length() > 512) {
                throw new IllegalArgumentException("URL path too long: " + urlPath);
            }
            this._log.debug("URLTemplateProvider: loading " + url + "(" + path + "," + urlPath + ")");
            URLTemplate t = new URLTemplate(this._broker, url);
            this._log.debug("**PARSING " + url);
            t.parse();
            return t;
        }
        catch (IOException e) {
            this._log.debug(e.getClass().getName() + " " + e.getMessage());
            if (mid != null) {
                try {
                    String p = this.buildPath(pre, mid, post);
                    return (Template)this._broker.get(_TYPE, p);
                }
                catch (Exception ex) {
                    this._log.debug(ex.getClass().getName() + " " + ex.getMessage());
                }
            }
            this._log.error("URLTemplateProvider(1): Could not load template: " + path, e);
        }
        catch (Exception e) {
            this._log.error("URLTemplateProvider(2): Could not load template: " + path, e);
        }
        this._log.debug("URLTemplateProvider: " + path + " not found.");
        return null;
    }

    private Template getTemplate(String path) throws IOException {
        this._log.debug("getTemplate: " + path);
        for (int i = 0; i < this._templateDirectory.length; ++i) {
            String tPart = this._templateDirectory[i];
            URL url = null;
            if (tPart.startsWith(CLASSPATH_PREFIX)) {
                url = this.searchClasspath(this.join(tPart = tPart.substring(CLASSPATH_PREFIX_LENGTH), path));
                if (url == null) {
                    throw new FileNotFoundException("Unable to locate " + path + " on classpath");
                }
            } else {
                if (tPart.startsWith(CONTEXT_PREFIX)) {
                    throw new IllegalStateException("Not implemented");
                }
                if (tPart.startsWith(IGNORE_PREFIX)) {
                    url = new URL(path);
                } else {
                    String s = this.join(tPart, path);
                    try {
                        url = new URL(s);
                    }
                    catch (MalformedURLException e) {
                        url = new URL("file", null, s);
                    }
                }
            }
            if (!this.exists(url)) continue;
            return this.getTemplate(url);
        }
        return null;
    }

    private final String join(String pre, String post) {
        boolean second;
        this._log.debug("Joining <" + pre + "> + <" + post + ">");
        if (pre == null || pre.length() == 0) {
            return post;
        }
        if (post == null || post.length() == 0) {
            return pre;
        }
        boolean first = pre.endsWith(_SEP);
        if (first ^ (second = post.startsWith(_SEP))) {
            return pre + post;
        }
        if (first) {
            return pre.substring(0, pre.length() - 1) + post;
        }
        if (second) {
            return first + post.substring(1);
        }
        return pre + _SEP + post;
    }

    private final URL searchClasspath(String resource) {
        this._log.debug("Searching classpath for " + resource);
        URL url = null;
        ClassLoader cl = this.getClass().getClassLoader();
        url = cl != null ? cl.getResource(resource) : ClassLoader.getSystemResource(resource);
        if (url != null) {
            return url;
        }
        String[] parts = this.parseLocalePath(resource);
        if (parts != null && parts[1] != null) {
            resource = this.buildPath(parts[0], parts[1], parts[2]);
            return this.searchClasspath(resource);
        }
        return null;
    }

    private final String stripLast(String s) {
        if (s == null) {
            return null;
        }
        int p = s.lastIndexOf("_");
        if (p < 0) {
            return null;
        }
        String ret = s.substring(0, p);
        return "".equals(ret) ? null : ret;
    }

    private final String buildPath(String pre, String mid, String post) {
        StringBuffer sb = new StringBuffer(pre);
        String stripped = this.stripLast(mid);
        if (stripped != null) {
            sb.append(_OPEN);
            sb.append(stripped);
            sb.append(_CLOSE);
        }
        sb.append(post);
        return sb.toString();
    }

    private String[] parseLocalePath(String path) {
        int p1 = path.indexOf(_OPEN);
        int p2 = path.indexOf(_CLOSE);
        if (p1 < 0 || p2 < 0 || p2 < p1) {
            return null;
        }
        String pre = path.substring(0, p1);
        String mid = path.substring(p1 + 1, p2);
        String post = path.substring(p2 + 1);
        return new String[]{pre, mid, post};
    }
}

