/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.ResourceException;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CachingProvider;
import org.webmacro.util.Settings;

public final class UrlProvider
extends CachingProvider {
    public static final long AVG_TIMEOUT = 10000L;
    public static final long MAX_TIMEOUT = 60000L;
    public static final long MIN_TIMEOUT = 5000L;
    Broker _broker;
    private String defaultEncoding;

    public final String getType() {
        return "url";
    }

    public void init(Broker b, Settings config) throws InitException {
        super.init(b, config);
        this._broker = b;
        this.defaultEncoding = config.getSetting("TemplateEncoding");
    }

    public final Object load(String name, CacheElement ce) throws ResourceException {
        try {
            int num;
            InputStream is;
            URLConnection uc;
            URL u = name.indexOf(":") < 3 ? new URL("file", null, -1, name) : new URL(name);
            try {
                uc = u.openConnection();
                is = uc.getInputStream();
            }
            catch (IOException e) {
                if (name.indexOf(":") < 3) {
                    uc = this._broker.getResource(name).openConnection();
                    is = uc.getInputStream();
                }
                e.printStackTrace();
                throw e;
            }
            String encoding = uc.getContentEncoding();
            if (encoding == null) {
                encoding = this.defaultEncoding;
            }
            InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(is), encoding);
            int length = uc.getContentLength();
            if (length == -1) {
                length = 1024;
            }
            char[] buf = new char[1024];
            StringWriter sw = new StringWriter(length);
            while ((num = in.read(buf)) != -1) {
                sw.write(buf, 0, num);
            }
            ((Reader)in).close();
            return sw.toString();
        }
        catch (Exception e) {
            throw new ResourceException(this + " unable to load " + name, e);
        }
    }

    public static long getUrlLastModified(URL u) {
        String protocol = u.getProtocol();
        if (protocol.equals("file")) {
            File f = new File(u.getFile());
            return f.lastModified();
        }
        if (protocol.equals("jar")) {
            String source = u.getFile();
            int lastIndex = source.lastIndexOf("!");
            if (lastIndex > 0) {
                source = source.substring(0, lastIndex);
            }
            try {
                return UrlProvider.getUrlLastModified(new URL(source));
            }
            catch (MalformedURLException e) {
                return 0L;
            }
        }
        try {
            URLConnection uc = u.openConnection();
            uc.connect();
            return uc.getLastModified();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static InputStream getUrlInputStream(URL u) throws IOException {
        if (u.getProtocol().equals("file")) {
            FileInputStream is = new FileInputStream(new File(u.getFile()));
            return is;
        }
        return u.openStream();
    }
}

