/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.servlet.ServletBroker;
import org.webmacro.util.LogSystem;

public class Servlet20Broker
extends ServletBroker {
    protected ClassLoader _servletClassLoader;

    protected Servlet20Broker(ServletContext sc, ClassLoader cl, Properties additionalProperties) throws InitException {
        super(sc);
        this._servletClassLoader = cl;
        String propertySource = "WebMacro.defaults, WebMacro.properties";
        this.loadDefaultSettings();
        this.loadSettings("WebMacro.properties", true);
        if (additionalProperties != null && additionalProperties.keySet().size() > 0) {
            propertySource = propertySource + ", (additional Properties)";
            this.loadSettings(additionalProperties);
        }
        propertySource = propertySource + ", (System Properties)";
        this.loadSystemSettings();
        this.initLog(this._config);
        this._log.notice("Loaded settings from " + propertySource);
        this.init();
    }

    public static Broker getBroker(Servlet s, Properties additionalProperties) throws InitException {
        ServletContext sc = s.getServletConfig().getServletContext();
        ClassLoader cl = s.getClass().getClassLoader();
        return Servlet20Broker._getBroker(sc, cl, additionalProperties, true, s.getClass().getName());
    }

    public static Broker getBroker(ServletContext sc, ClassLoader cl, Properties additionalProperties) throws InitException {
        return Servlet20Broker._getBroker(sc, cl, additionalProperties, false, sc.toString());
    }

    protected static Broker _getBroker(ServletContext sc, ClassLoader cl, Properties additionalProperties, boolean fromServlet, String servletOrContextName) throws InitException {
        try {
            Broker b;
            Object key = cl;
            if (additionalProperties != null && additionalProperties.keySet().size() > 0) {
                key = new ServletBroker.PropertiesPair(cl, additionalProperties);
            }
            if ((b = Servlet20Broker.findBroker(key)) == null) {
                b = new Servlet20Broker(sc, cl, additionalProperties);
                Servlet20Broker.register(key, b);
            } else {
                b.getLog("broker").notice((fromServlet ? "Servlet " : "ServletContext ") + servletOrContextName + " joining Broker" + " " + b.getName());
            }
            return b;
        }
        catch (InitException e) {
            Log log = LogSystem.getSystemLog("wm");
            log.error("Failed to initialized WebMacro from " + (fromServlet ? "Servlet " : "ServletContext ") + servletOrContextName);
            throw e;
        }
    }

    public URL getResource(String name) {
        URL u = this._servletClassLoader.getResource(name);
        if (u == null) {
            u = super.getResource(name);
        }
        return u;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = this._servletClassLoader.getResourceAsStream(name);
        if (is == null) {
            is = super.getResourceAsStream(name);
        }
        return is;
    }

    public Class classForName(String name) throws ClassNotFoundException {
        Class cls = null;
        try {
            cls = this._servletClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (cls == null) {
            cls = super.classForName(name);
        }
        return cls;
    }
}

