/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.servlet.ServletBroker;
import org.webmacro.util.LogSystem;

public class Servlet22Broker
extends ServletBroker {
    protected final ClassLoader _servletClassLoader;
    protected String _templatePrefix;

    protected Servlet22Broker(ServletContext sc, ClassLoader cl, Properties additionalProperties) throws InitException {
        super(sc);
        this._servletClassLoader = cl;
        String propertySource = "WebMacro.defaults";
        this.loadDefaultSettings();
        boolean loaded = this.loadSettings("WEB-INF/WebMacro.properties", true);
        if (loaded) {
            propertySource = propertySource + ", WEB-INF/WebMacro.properties";
        } else {
            this.loadSettings("WebMacro.properties", true);
            propertySource = propertySource + ", WebMacro.properties";
        }
        propertySource = propertySource + ", (WAR file)";
        this.loadServletSettings("org.webmacro");
        if (additionalProperties != null && additionalProperties.keySet().size() > 0) {
            propertySource = propertySource + ", (additional Properties)";
            this.loadSettings(additionalProperties);
        }
        propertySource = propertySource + ", (System Properties)";
        this.loadSystemSettings();
        this.initLog(this._config);
        this._log.notice("Loaded settings from " + propertySource);
        this.init();
    }

    protected void loadServletSettings(String prefix) throws InitException {
        Properties p = new Properties();
        Enumeration e = this._servletContext.getInitParameterNames();
        if (e != null) {
            String dotPrefix;
            String string = dotPrefix = prefix == null ? "" : prefix + ".";
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (prefix == null) {
                    p.setProperty(key, this._servletContext.getInitParameter(key));
                    continue;
                }
                if (!key.startsWith(dotPrefix)) continue;
                p.setProperty(key, this._servletContext.getInitParameter(key).substring(dotPrefix.length()));
            }
        }
        this._config.load(p, prefix);
    }

    protected void init() throws InitException {
        super.init();
        String s = this.getSetting("Servlet22Broker.TemplateLocation");
        this._templatePrefix = s == null || s.trim().equals("") ? null : (s.endsWith("/") ? s : s + "/");
    }

    public static Broker getBroker(Servlet s, Properties additionalProperties) throws InitException {
        ServletContext sc = s.getServletConfig().getServletContext();
        ClassLoader cl = s.getClass().getClassLoader();
        return Servlet22Broker._getBroker(sc, cl, additionalProperties, true, s.getClass().getName());
    }

    public static Broker getBroker(ServletContext sc, ClassLoader cl, Properties additionalProperties) throws InitException {
        return Servlet22Broker._getBroker(sc, cl, additionalProperties, false, sc.toString());
    }

    private static Broker _getBroker(ServletContext sc, ClassLoader cl, Properties additionalProperties, boolean fromServlet, String servletOrContextName) throws InitException {
        Broker result;
        try {
            Broker b;
            Object key = sc;
            if (additionalProperties != null && additionalProperties.keySet().size() > 0) {
                key = new ServletBroker.PropertiesPair(sc, additionalProperties);
            }
            if ((b = Servlet22Broker.findBroker(key)) == null) {
                b = new Servlet22Broker(sc, cl, additionalProperties);
                Servlet22Broker.register(key, b);
            } else {
                b.getLog("broker").notice((fromServlet ? "Servlet " : "ServletContext ") + servletOrContextName + " joining Broker" + " " + b.getName());
            }
            result = b;
        }
        catch (InitException e) {
            Log log = LogSystem.getSystemLog("wm");
            log.error("Failed to initialized WebMacro from " + (fromServlet ? "Servlet " : "ServletContext ") + servletOrContextName);
            throw e;
        }
        return result;
    }

    public URL getResource(String name) {
        try {
            File f;
            String contextName = name;
            if (name.startsWith("/")) {
                name = name.substring(1);
            } else {
                StringBuffer b = new StringBuffer(name.length() + 1);
                b.append("/");
                b.append(name);
                contextName = b.toString();
            }
            URL u = this._servletContext.getResource(contextName);
            if (u != null && u.getProtocol().equals("file") && !(f = new File(u.getFile())).exists()) {
                u = null;
            }
            if (u == null) {
                u = this._servletClassLoader.getResource(name);
            }
            if (u == null) {
                u = super.getResource(name);
            }
            return u;
        }
        catch (MalformedURLException e) {
            this._log.warning("MalformedURLException caught in ServletBroker.getResource for " + name);
            return null;
        }
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = this._servletContext.getResourceAsStream(name);
        if (is == null) {
            is = this._servletClassLoader.getResourceAsStream(name);
        }
        if (is == null) {
            is = super.getResourceAsStream(name);
        }
        return is;
    }

    public URL getTemplate(String name) {
        if (this._templatePrefix == null) {
            return this.getResource(name);
        }
        URL u = this.getResource(this._templatePrefix + name);
        return u != null ? u : this.getResource(name);
    }

    public Class classForName(String name) throws ClassNotFoundException {
        Class cls = null;
        try {
            cls = this._servletClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (cls == null) {
            cls = super.classForName(name);
        }
        return cls;
    }
}

