/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.webmacro.Broker;
import org.webmacro.WebMacroException;
import org.webmacro.servlet.TextTool;

public final class Instantiator {
    private static final String IMPLIED_PACKAGES = "ImpliedPackages";
    private static final String ALLOWED_PACKAGES = "AllowedPackages";
    private static final String DEPRECATED_IMPLIED_PACKAGES = "BeanDirective.ImpliedPackages";
    private static final String DEPRECATED_ALLOWED_PACKAGES = "BeanDirective.AllowedPackages";
    private static final String INSTANTIATOR_KEY = "org.webmacro.util.Instantiator";
    private List _impliedPackages;
    private List _allowedPackages;
    private Broker _broker;

    private Instantiator(Broker b) {
        this._broker = b;
        String s = b.getSetting(IMPLIED_PACKAGES);
        if (s == null && (s = b.getSetting(DEPRECATED_IMPLIED_PACKAGES)) != null) {
            b.getLog("engine").warning("The configuration parameter \"BeanDirective.ImpliedPackages\" has been deprecated! Use \"ImpliedPackages\" instead.");
        }
        this._impliedPackages = s == null ? Collections.EMPTY_LIST : Arrays.asList(TextTool.split(s, ","));
        s = b.getSetting(ALLOWED_PACKAGES);
        if (s == null && (s = b.getSetting(DEPRECATED_ALLOWED_PACKAGES)) != null) {
            b.getLog("engine").warning("The configuration parameter \"BeanDirective.AllowedPackages\" has been deprecated! Use \"AllowedPackages\" instead.");
        }
        this._allowedPackages = s == null ? Collections.EMPTY_LIST : Arrays.asList(TextTool.split(s, ","));
    }

    public List getImpliedPackages() {
        return this._impliedPackages;
    }

    public List getAllowedPackages() {
        return this._allowedPackages;
    }

    public Class classForName(String className) throws WebMacroException {
        String pkg;
        Class c = null;
        ClassNotFoundException except = null;
        if (className.indexOf(46) >= 0) {
            try {
                c = this._broker.classForName(className);
            }
            catch (ClassNotFoundException cnfe) {
                except = cnfe;
            }
        } else {
            for (int i = 0; i < this._impliedPackages.size(); ++i) {
                String s = (String)this._impliedPackages.get(i);
                try {
                    c = this._broker.classForName(s + "." + className);
                    break;
                }
                catch (ClassNotFoundException cnfe2) {
                    except = cnfe2;
                    continue;
                }
            }
        }
        if (c == null) {
            throw new WebMacroException("Unable to load class " + className, except);
        }
        if (!this._allowedPackages.isEmpty() && !this._allowedPackages.contains(pkg = c.getPackage().getName())) {
            throw new WebMacroException("You are not permitted to load classes from this package (" + pkg + ").  Check the \"" + ALLOWED_PACKAGES + "\" parameter in the WebMacro configuration.");
        }
        return c;
    }

    public Object instantiate(Class c, Object[] args) throws Exception {
        Object o = null;
        if (args == null) {
            o = c.newInstance();
        } else {
            Constructor<?>[] cons = c.getConstructors();
            for (int i = 0; i < cons.length; ++i) {
                if (cons[i].getParameterTypes().length != args.length) continue;
                try {
                    o = cons[i].newInstance(args);
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (o == null) {
                throw new InstantiationException("Unable to construct object of type " + c.getName() + " using the supplied arguments: " + Arrays.asList(args).toString());
            }
        }
        return o;
    }

    public static synchronized Instantiator getInstance(Broker b) {
        Instantiator instantiator = (Instantiator)b.getBrokerLocal(INSTANTIATOR_KEY);
        if (instantiator == null) {
            instantiator = new Instantiator(b);
            b.setBrokerLocal(INSTANTIATOR_KEY, instantiator);
        }
        return instantiator;
    }
}

