/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.util.Date;
import org.webmacro.Log;
import org.webmacro.util.Clock;
import org.webmacro.util.LogSystem;
import org.webmacro.util.LogTarget;

public class LogSource
implements Log {
    private final String _type;
    private final String _description;
    private final String _category;
    private int _tCount = 0;
    private final LogTarget[][] _targets = new LogTarget[5][];

    public final boolean hasTargets() {
        return this._tCount != 0;
    }

    LogSource(String category, String type, String description) {
        this._category = category;
        this._type = type;
        this._description = description;
    }

    public String getType() {
        return this._type;
    }

    public String getDescription() {
        return this._description;
    }

    public String getCategory() {
        return this._category;
    }

    public String toString() {
        return "LogSource(" + this._category + "," + this._type + "," + this._description + ")";
    }

    void addTarget(LogTarget t, int level) {
        if (level < 0 || level > 5) {
            this.error("Attempt to target with invalid log level: " + level);
            return;
        }
        LogTarget[] ts = this._targets[level];
        if (ts == null) {
            ts = new LogTarget[]{t};
            this._targets[level] = ts;
            ++this._tCount;
            return;
        }
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i] != t) continue;
            return;
        }
        LogTarget[] nts = new LogTarget[ts.length + 1];
        System.arraycopy(ts, 0, nts, 0, ts.length);
        nts[ts.length] = t;
        this._targets[level] = nts;
        ++this._tCount;
    }

    void removeTarget(LogTarget t, int level) {
        LogTarget[] ts = this._targets[level];
        if (ts == null) {
            return;
        }
        boolean match = false;
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i] != t) continue;
            match = true;
        }
        if (!match) {
            return;
        }
        --this._tCount;
        if (ts.length == 1) {
            this._targets[level] = null;
        }
        LogTarget[] nts = new LogTarget[ts.length - 1];
        int pos = 0;
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i] == t) continue;
            nts[pos++] = ts[i];
        }
        this._targets[level] = nts;
    }

    public void debug(String msg, Throwable e) {
        this.log(0, msg, e);
    }

    public void debug(String msg) {
        this.log(0, msg, null);
    }

    public void info(String msg) {
        this.log(1, msg, null);
    }

    public void notice(String msg) {
        this.log(2, msg, null);
    }

    public void warning(String msg, Throwable e) {
        this.log(3, msg, e);
    }

    public void warning(String msg) {
        this.log(3, msg, null);
    }

    public void error(String msg) {
        this.log(4, msg, null);
    }

    public void error(String msg, Throwable e) {
        this.log(4, msg, e);
    }

    public boolean loggingDebug() {
        return this._targets[0] != null;
    }

    public boolean loggingInfo() {
        return this._targets[1] != null;
    }

    public boolean loggingNotice() {
        return this._targets[2] != null;
    }

    public boolean loggingWarning() {
        return this._targets[3] != null;
    }

    protected void log(int level, String msg, Throwable e) {
        LogTarget[] targets = this._targets[level];
        if (targets == null) {
            return;
        }
        String sLevel = LogSystem.LEVELS[level];
        Date date = Clock.getDate();
        boolean flush = level >= 2;
        for (int i = 0; i < targets.length; ++i) {
            targets[i].log(date, this._type, sLevel, msg, e);
            if (!flush) continue;
            targets[i].flush();
        }
    }
}

