/*
 * Decompiled with CFR 0.152.
 */
package easysoft.rpc;

import easysoft.rpc.rpcException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.sql.SQLException;

public class Packet {
    DataInputStream sin;
    DataOutputStream sout;
    public Socket socket;
    byte packetSequence;
    public int bpos;
    public int packetLength;
    public boolean TRACING = false;
    public final int HEADERLENGTH = 4;
    public final int MAXBUFFER = 65535;
    public int maxMemory = 0;
    public final int NETWORK_BUFFER_SIZE = 4096;
    byte[] buffer = new byte[4103];
    public boolean swapBytes = false;

    public Packet() {
        this.buffer = new byte[24];
    }

    public Packet(DataInputStream dataInputStream, DataOutputStream dataOutputStream, Socket socket) {
        this.sin = dataInputStream;
        this.sout = dataOutputStream;
        this.socket = socket;
    }

    public Packet(DataInputStream dataInputStream, DataOutputStream dataOutputStream, Socket socket, boolean bl) {
        this.sin = dataInputStream;
        this.sout = dataOutputStream;
        this.swapBytes = bl;
        this.socket = socket;
    }

    synchronized void clear() {
        this.bpos = 4;
    }

    synchronized int currentPos() {
        return this.bpos;
    }

    synchronized void fillBuffer(byte by, int n) {
        this.buffer[0] = by;
        int n2 = 0;
        while (n2 < n) {
            this.buffer[n2] = by;
            ++n2;
        }
    }

    synchronized boolean isLastDataPacket() {
        return this.packetLength == 1 && this.ub(this.buffer[0]) == 254;
    }

    synchronized void next() throws rpcException, SQLException {
        byte[] byArray = new byte[4];
        try {
            int n = 0;
            while (n < 4) {
                byArray[n] = this.sin.readByte();
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new rpcException(iOException.getMessage());
        }
        try {
            this.packetLength = this.ub(byArray[3]) + 256 * this.ub(byArray[2]) + 65536 * this.ub(byArray[1]) + 0x1000000 * this.ub(byArray[0]);
            if (this.packetLength > 65535) {
                this.packetLength = this.sin.read(this.buffer, 0, 65535);
                this.showBuffer(this.packetLength);
                throw new rpcException("Too Large Packet from server");
            }
            if (this.packetLength < 0) {
                this.sin.read(this.buffer, 0, 1000);
                String string = this.readLenString(1000L);
                throw new SQLException(string);
            }
            this.sin.readFully(this.buffer, 0, this.packetLength);
            if (this.TRACING) {
                // empty if block
            }
            this.bpos = 0;
            if (this.TRACING) {
                int n = 0;
                while (n < this.packetLength) {
                    System.out.println(n + this.buffer[n] + "XX : " + this.ub(this.buffer[n]) + "  : ");
                    if (this.buffer[n] > 30) {
                        System.out.println(this.buffer[n]);
                    } else {
                        System.out.println("");
                    }
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            throw new rpcException(iOException.getMessage());
        }
    }

    synchronized void pushInt32(long l) {
        if (this.swapBytes) {
            this.write4BytesSwap(l);
        } else if (l < 0L) {
            long l2 = l % 256L + 256L;
            this.writeByte((byte)l2);
            l2 = (l /= 256L) % 256L + 255L;
            this.writeByte((byte)l2);
            l2 = (l /= 256L) % 256L + 255L;
            this.writeByte((byte)l2);
            l2 = (l /= 256L) % 256L + 255L;
            this.writeByte((byte)l2);
        } else {
            long l3 = l % 256L;
            this.buffer[this.bpos++] = this.ub2((short)l3);
            l3 = (l /= 256L) % 256L;
            this.buffer[this.bpos++] = this.ub((short)l3);
            l3 = (l /= 256L) % 256L;
            this.buffer[this.bpos++] = this.ub((short)l3);
            this.buffer[this.bpos++] = this.ub((short)(l /= 256L));
        }
    }

    synchronized int read2Bytes() {
        if (this.swapBytes) {
            return 256 * this.ub(this.buffer[this.bpos++]) + this.ub(this.buffer[this.bpos++]);
        }
        return this.ub(this.buffer[this.bpos++]) + 256 * this.ub(this.buffer[this.bpos++]);
    }

    synchronized int read3Bytes() {
        return this.ub(this.buffer[this.bpos++]) + 256 * this.ub(this.buffer[this.bpos++]) + 65536 * this.ub(this.buffer[this.bpos++]);
    }

    synchronized long read4Bytes() {
        if (this.swapBytes) {
            return 0x1000000 * this.ub(this.buffer[this.bpos++]) + 65536 * this.ub(this.buffer[this.bpos++]) + 256 * this.ub(this.buffer[this.bpos++]) + this.ub(this.buffer[this.bpos++]);
        }
        return this.ub(this.buffer[this.bpos++]) + 256 * this.ub(this.buffer[this.bpos++]) + 65536 * this.ub(this.buffer[this.bpos++]) + 0x1000000 * this.ub(this.buffer[this.bpos++]);
    }

    synchronized byte readByte() {
        return this.buffer[this.bpos++];
    }

    synchronized long readLength() {
        switch (this.ub(this.buffer[this.bpos])) {
            case 251: {
                ++this.bpos;
                return 0L;
            }
            case 252: {
                ++this.bpos;
                return this.read2Bytes();
            }
            case 253: {
                ++this.bpos;
                return this.read3Bytes();
            }
            case 254: {
                ++this.bpos;
                return this.read4Bytes();
            }
        }
        return this.ub(this.buffer[this.bpos++]);
    }

    synchronized byte[] readLenMemory(int n) throws rpcException, SQLException {
        int n2 = 0;
        int n3 = 0;
        if (this.maxMemory > 0 && n > this.maxMemory) {
            rpcException rpcException2 = new rpcException("Data available from the server is " + n + " bytes\n This exceeeds the maximum amount set at " + this.maxMemory + " bytes\n You can change this limit by adding \":mb=<float>\" to set the limit to <float> number of Mega Bytes.");
            rpcException2.printStackTrace();
            throw rpcException2;
        }
        byte[] byArray = new byte[]{};
        if (n == 0) {
            return byArray;
        }
        byArray = new byte[n];
        if (n <= this.buffer.length - this.bpos) {
            int n4 = 0;
            while (n4 < n) {
                byArray[n4] = this.buffer[this.bpos++];
                ++n4;
            }
            return byArray;
        }
        int n5 = this.bpos;
        while (n5 < this.packetLength) {
            byArray[n2++] = this.buffer[n5];
            ++n5;
        }
        while (n2 < n) {
            this.next();
            n3 = n - n2 > this.packetLength ? this.packetLength : n - n2;
            while (this.bpos < n3) {
                byArray[n2++] = this.buffer[this.bpos];
                ++this.bpos;
            }
        }
        return byArray;
    }

    synchronized String readLenString() throws UnsupportedEncodingException {
        long l = this.packetLength;
        if (l == 0L) {
            return new String("");
        }
        StringBuffer stringBuffer = new StringBuffer((int)l);
        int n = 0;
        while ((long)n < l) {
            if (this.buffer[this.bpos] == 0) break;
            stringBuffer.append((char)this.buffer[this.bpos++]);
            ++n;
        }
        return stringBuffer.toString();
    }

    synchronized String readLenString(long l) {
        int n = this.bpos + (int)l;
        int n2 = this.bpos;
        if (l == 0L) {
            return new String("");
        }
        StringBuffer stringBuffer = new StringBuffer((int)l);
        int n3 = 0;
        while ((long)n3 < l) {
            if (this.buffer[this.bpos] == 0) {
                this.bpos = n;
                break;
            }
            stringBuffer.append((char)this.ub(this.buffer[this.bpos++]));
            ++n3;
        }
        return stringBuffer.toString();
    }

    synchronized void readNBytes(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.readByte();
            ++n2;
        }
    }

    public synchronized String readPacket() throws SQLException {
        try {
            this.next();
        }
        catch (rpcException rpcException2) {
            throw new SQLException("Socket Communication Error : " + rpcException2.getMessage());
        }
        try {
            return this.readLenString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
    }

    synchronized String readString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.bpos;
        while (this.buffer[n] != 0) {
            stringBuffer.append((char)this.buffer[n++]);
        }
        this.bpos = n + 1;
        return stringBuffer.toString();
    }

    synchronized void resetPacketSequence() {
        this.packetSequence = (byte)-1;
    }

    synchronized void send() throws SQLException {
        try {
            int n = this.bpos;
            this.buffer[this.bpos] = 0;
            this.bpos = 0;
            this.write4Bytes(n - 4);
            if (this.TRACING) {
                int n2 = 0;
                while (n2 < n) {
                    System.out.println(n2 + " : " + this.ub(this.buffer[n2]) + "  : ");
                    if (this.buffer[n2] > 30) {
                        System.out.println(this.buffer[n2]);
                    } else {
                        System.out.println("");
                    }
                    ++n2;
                }
            }
            this.sout.write(this.buffer, 0, n);
            this.sout.flush();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            throw new SQLException("Socket Communication Error : " + string);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void sendByteArray(byte[] var1_1) throws SQLException {
        block6: {
            block5: {
                var2_2 = this.bpos;
                var3_3 = 0;
                this.pushInt32(var1_1.length);
                if (4096 - this.bpos <= var1_1.length) break block5;
                var4_4 = 0;
                while (var4_4 < var1_1.length) {
                    this.buffer[this.bpos++] = var1_1[var4_4];
                    ++var4_4;
                }
                break block6;
            }
            var4_5 = 4096 - this.bpos;
            while (var3_3 < var4_5) {
                this.buffer[this.bpos++] = var1_1[var3_3];
                ++var3_3;
            }
            this.send();
            ** GOTO lbl24
            {
                this.buffer[this.bpos] = var1_1[var3_3++];
                ++this.bpos;
                do {
                    if (this.bpos < 4096) continue block2;
                    this.send();
lbl24:
                    // 2 sources

                } while (var1_1.length - var3_3 > 4096);
            }
            while (var3_3 < var1_1.length) {
                this.buffer[this.bpos++] = var1_1[var3_3];
                ++var3_3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void sendByteArray(byte[] var1_1, int var2_2) throws SQLException {
        block6: {
            block5: {
                var3_3 = this.bpos;
                var4_4 = 0;
                this.pushInt32(var2_2);
                if (4096 - this.bpos <= var2_2) break block5;
                var5_5 = 0;
                while (var5_5 < var2_2) {
                    this.buffer[this.bpos++] = var1_1[var5_5];
                    ++var5_5;
                }
                break block6;
            }
            var5_6 = 4096 - this.bpos;
            while (var4_4 < var5_6) {
                this.buffer[this.bpos++] = var1_1[var4_4];
                ++var4_4;
            }
            this.send();
            ** GOTO lbl24
            {
                this.buffer[this.bpos] = var1_1[var4_4++];
                ++this.bpos;
                do {
                    if (this.bpos < 4096) continue block2;
                    this.send();
lbl24:
                    // 2 sources

                } while (var2_2 - var4_4 > 4096);
            }
            while (var4_4 < var2_2) {
                this.buffer[this.bpos++] = var1_1[var4_4];
                ++var4_4;
            }
        }
    }

    synchronized void setPos(int n) {
        this.bpos = n;
    }

    synchronized void showBuffer(int n) {
        int n2 = 0;
        while (n2 < n) {
            if (this.buffer[n2] > 30) {
                System.out.print((char)this.buffer[n2]);
            } else {
                System.out.print("");
            }
            System.out.println("     ;" + n2 + " : " + this.ub(this.buffer[n2]) + "  : ");
            ++n2;
        }
    }

    public synchronized int ub(byte n) {
        return n < 0 ? 256 + n : n;
    }

    synchronized byte ub(short s) {
        return s < 0 ? (byte)(s + 256) : (byte)s;
    }

    byte ub2(short s) {
        return s < 0 ? (byte)(s + 256) : (byte)s;
    }

    synchronized void write2Bytes(int n) {
        int n2 = n % 256;
        int n3 = n / 256;
        int n4 = n3 = n < 0 ? n3 + 255 : n3;
        if (this.swapBytes) {
            this.writeByte((byte)n3);
            this.writeByte((byte)n2);
        } else {
            this.writeByte((byte)n2);
            this.writeByte((byte)n3);
        }
    }

    synchronized void write3Bytes(int n) {
        this.bpos += 2;
        int n2 = n % 256;
        this.buffer[this.bpos--] = this.ub((short)n2);
        n2 = (n /= 256) % 256;
        this.buffer[this.bpos--] = this.ub((short)n2);
        this.buffer[this.bpos] = this.ub((short)(n /= 256));
        this.bpos += 2;
    }

    synchronized void write4Bytes(long l) {
        int n = this.bpos;
        this.bpos += 3;
        long l2 = l % 256L;
        this.buffer[this.bpos--] = this.ub((short)l2);
        l2 = (l /= 256L) % 256L;
        this.buffer[this.bpos--] = this.ub((short)l2);
        l2 = (l /= 256L) % 256L;
        this.buffer[this.bpos--] = this.ub((short)l2);
        this.buffer[this.bpos] = this.ub((short)(l /= 256L));
        this.bpos += 4;
    }

    synchronized void write4BytesSwap(long l) {
        if (l < 0L) {
            this.bpos += 3;
            long l2 = l % 256L + 256L;
            this.buffer[this.bpos--] = (byte)l2;
            l2 = (l /= 256L) % 256L + 255L;
            this.buffer[this.bpos--] = (byte)l2;
            l2 = (l /= 256L) % 256L + 255L;
            this.buffer[this.bpos--] = (byte)l2;
            l2 = (l /= 256L) % 256L + 255L;
            this.buffer[this.bpos] = (byte)l2;
        } else {
            this.bpos += 3;
            long l3 = l % 256L;
            this.buffer[this.bpos--] = this.ub((short)l3);
            l3 = (l /= 256L) % 256L;
            this.buffer[this.bpos--] = this.ub((short)l3);
            l3 = (l /= 256L) % 256L;
            this.buffer[this.bpos--] = this.ub((short)l3);
            this.buffer[this.bpos] = this.ub((short)(l /= 256L));
            this.bpos += 4;
        }
    }

    synchronized byte[] write4BytesSwap(long l, int n, byte[] byArray) {
        if (l < 0L) {
            n += 3;
            long l2 = l % 256L + 256L;
            byArray[n--] = (byte)l2;
            l2 = (l /= 256L) % 256L + 255L;
            byArray[n--] = (byte)l2;
            l2 = (l /= 256L) % 256L + 255L;
            byArray[n--] = (byte)l2;
            l2 = (l /= 256L) % 256L + 255L;
            byArray[n] = (byte)l2;
        } else {
            n += 3;
            long l3 = l % 256L;
            byArray[n--] = this.ub((short)l3);
            l3 = (l /= 256L) % 256L;
            byArray[n--] = this.ub((short)l3);
            l3 = (l /= 256L) % 256L;
            byArray[n--] = this.ub((short)l3);
            byArray[n] = this.ub((short)(l /= 256L));
            n += 4;
        }
        return byArray;
    }

    public synchronized byte[] write4Bytes(long l, int n, byte[] byArray) {
        int n2 = n;
        if (this.swapBytes) {
            return this.write4BytesSwap(l, n, byArray);
        }
        if (l < 0L) {
            byArray[n++] = (byte)(l % 256L + 256L);
            byArray[n++] = (byte)((l /= 256L) % 256L + 255L);
            byArray[n++] = (byte)((l /= 256L) % 256L + 255L);
            byArray[n++] = (byte)((l /= 256L) % 256L + 255L);
        } else {
            long l2 = l % 256L;
            byArray[n++] = this.ub((short)l2);
            l2 = (l /= 256L) % 256L;
            byArray[n++] = this.ub((short)l2);
            l2 = (l /= 256L) % 256L;
            byArray[n++] = this.ub((short)l2);
            byArray[n++] = this.ub((short)(l /= 256L));
        }
        return byArray;
    }

    synchronized void writeByte(byte by) {
        this.buffer[this.bpos++] = by;
    }

    synchronized void writeString(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.buffer[this.bpos++] = (byte)string.charAt(n2);
            ++n2;
        }
        this.buffer[this.bpos++] = 0;
    }

    synchronized void writeStringNoNull(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.buffer[this.bpos++] = (byte)string.charAt(n2);
            ++n2;
        }
    }
}

