/*
 * Decompiled with CFR 0.152.
 */
package easysoft.sql;

import easysoft.rpc.Packet;
import easysoft.rpc.Stub;
import easysoft.sql.jobPreparedStatement2;
import easysoft.sql.jobResultSet;
import easysoft.sql.jobTrace;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.Timestamp;

public class BPS {
    byte[] oneGoData = new byte[128];
    int oneGoDataSize = 0;
    Packet packet;
    jobResultSet jrs;
    jobPreparedStatement2 pstmt;
    Stub rpc;
    long hStmt = 0L;
    int setsCount = 1;
    int parameterCount = 0;
    int parameterArraySize = 6;
    int batchArraySize = 10;
    byte[][][] batchArrayData = new byte[this.batchArraySize][this.parameterArraySize][];
    String[][] batchArrayStringData = new String[this.batchArraySize][this.parameterArraySize];
    int[][] batchArrayIndex = new int[this.batchArraySize][this.parameterArraySize];
    int[][] batchArrayType = new int[this.batchArraySize][this.parameterArraySize];
    int[][] batchArrayLength = new int[this.batchArraySize][this.parameterArraySize];
    int[] batchArrayCount = new int[this.batchArraySize];
    int[][] batchArrayParamType = new int[this.batchArraySize][this.parameterArraySize];
    int currentParameterSet = 1;

    public BPS(jobResultSet jobResultSet2) {
        this.jrs = jobResultSet2;
        this.rpc = jobResultSet2.rpc;
        this.packet = this.rpc.cl.packet;
        this.hStmt = jobResultSet2.hStmt;
        this.newParameterSet(1);
    }

    public BPS(jobPreparedStatement2 jobPreparedStatement22) {
        this.pstmt = jobPreparedStatement22;
        this.rpc = jobPreparedStatement22.rpc;
        this.packet = this.rpc.cl.packet;
        this.hStmt = jobPreparedStatement22.hStmt;
        this.newParameterSet(1);
    }

    void setOutputParam(int n, int n2, int n3) {
        int n4 = this.currentParameterSet - 1;
        int n5 = this.batchArrayCount[n4];
        this.paramSetGrow();
        this.batchArrayData[n4][n5] = null;
        this.batchArrayLength[n4][n5] = n3;
        this.batchArrayType[n4][n5] = n2;
        this.batchArrayParamType[n4][n5] = 1;
        this.batchArrayIndex[n4][n5] = n;
        this.batchArrayCount[n4] = n5 + 1;
    }

    void setParam(int n, int n2, byte[] byArray) {
        int n3 = this.currentParameterSet - 1;
        int n4 = this.batchArrayCount[n3];
        this.paramSetGrow();
        this.batchArrayData[n3][n4] = byArray;
        this.batchArrayLength[n3][n4] = byArray.length;
        this.batchArrayIndex[n3][n4] = n;
        this.batchArrayType[n3][n4] = n2;
        this.batchArrayParamType[n3][n4] = 0;
        this.batchArrayCount[n3] = n4 + 1;
    }

    void setParam(int n, int n2, String string) {
        int n3 = this.currentParameterSet - 1;
        int n4 = this.batchArrayCount[n3];
        this.paramSetGrow();
        this.batchArrayStringData[n3][n4] = string;
        this.batchArrayLength[n3][n4] = string == null ? -1 : 0;
        this.batchArrayIndex[n3][n4] = n;
        this.batchArrayType[n3][n4] = n2;
        this.batchArrayParamType[n3][n4] = 0;
        this.batchArrayCount[n3] = n4 + 1;
    }

    void paramSetGrow() {
        int n = this.currentParameterSet - 1;
        int n2 = this.batchArrayCount[n];
        jobTrace.println("paramSetGrow: paramIndex=" + n2);
        if (n2 < this.parameterArraySize) {
            return;
        }
        int n3 = this.parameterArraySize * 2;
        byte[][] byArrayArray = new byte[n3][];
        String[] stringArray = new String[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        jobTrace.println("Extending parameter set from " + this.parameterArraySize + "paramIndex=" + n2);
        int n4 = 0;
        while (n4 < n2) {
            byArrayArray[n4] = this.batchArrayData[n][n4];
            stringArray[n4] = this.batchArrayStringData[n][n4];
            nArray[n4] = this.batchArrayLength[n][n4];
            nArray2[n4] = this.batchArrayIndex[n][n4];
            nArray3[n4] = this.batchArrayType[n][n4];
            nArray4[n4] = this.batchArrayParamType[n][n4];
            ++n4;
        }
        this.batchArrayData[n] = byArrayArray;
        this.batchArrayStringData[n] = stringArray;
        this.batchArrayLength[n] = nArray;
        this.batchArrayIndex[n] = nArray2;
        this.batchArrayType[n] = nArray3;
        this.batchArrayParamType[n] = nArray4;
        this.parameterArraySize = n3;
    }

    void addBatch() {
        ++this.currentParameterSet;
        ++this.setsCount;
        this.newParameterSet(this.currentParameterSet);
    }

    void newParameterSet(int n) {
        if (n > this.batchArraySize) {
            int n2 = this.batchArraySize;
            this.batchArraySize *= 2;
            byte[][][] byArray = new byte[this.batchArraySize][this.parameterArraySize][];
            int[][] nArrayArray = new int[this.batchArraySize][];
            int[][] nArrayArray2 = new int[this.batchArraySize][];
            int[][] nArrayArray3 = new int[this.batchArraySize][];
            int[][] nArrayArray4 = new int[this.batchArraySize][];
            int[] nArray = new int[this.batchArraySize];
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = this.batchArrayData[n3];
                nArrayArray[n3] = this.batchArrayLength[n3];
                nArrayArray2[n3] = this.batchArrayIndex[n3];
                nArrayArray3[n3] = this.batchArrayType[n3];
                nArrayArray4[n3] = this.batchArrayParamType[n3];
                nArray[n3] = this.batchArrayCount[n3];
                ++n3;
            }
            this.batchArrayData = byArray;
            this.batchArrayLength = nArrayArray;
            this.batchArrayIndex = nArrayArray2;
            this.batchArrayType = nArrayArray3;
            this.batchArrayParamType = nArrayArray4;
            this.batchArrayCount = nArray;
        }
        this.batchArrayData[n - 1] = new byte[this.parameterArraySize][];
        this.batchArrayLength[n - 1] = new int[this.parameterArraySize];
        this.batchArrayIndex[n - 1] = new int[this.parameterArraySize];
        this.batchArrayType[n - 1] = new int[this.parameterArraySize];
        this.batchArrayParamType[n - 1] = new int[this.parameterArraySize];
        this.batchArrayCount[n - 1] = 0;
    }

    void setupBindings(int n) throws SQLException {
        int n2;
        int n3 = n - 1;
        int n4 = this.batchArrayCount[n3];
        int[] nArray = new int[n4 + 1];
        jobTrace.debug("setupBindings(ordinal=" + n + ")");
        this.oneGoDataSize = 4 + n4 * 16;
        int n5 = 1;
        while (n5 < n4 + 1) {
            n2 = this.batchArrayLength[n3][n5 - 1];
            this.oneGoDataSize = n2 == -1 ? ++this.oneGoDataSize : (this.oneGoDataSize += n2);
            ++n5;
        }
        if (this.oneGoData.length < this.oneGoDataSize) {
            this.oneGoData = new byte[this.oneGoDataSize];
        }
        this.packet.write4Bytes(n4, 0, this.oneGoData);
        n2 = 4;
        int n6 = 0;
        while (n6 < n4) {
            this.packet.write4Bytes(this.batchArrayIndex[n3][n6], n2, this.oneGoData);
            this.packet.write4Bytes(this.batchArrayType[n3][n6], n2 + 4, this.oneGoData);
            this.packet.write4Bytes(this.batchArrayParamType[n3][n6], n2 + 8, this.oneGoData);
            this.packet.write4Bytes(this.batchArrayLength[n3][n6], n2 + 12, this.oneGoData);
            if (this.batchArrayData[n3][n6] != null) {
                this.copyBytes(n2 + 16, this.oneGoData, this.batchArrayData[n3][n6]);
            }
            n2 = n2 + 16 + this.batchArrayLength[n3][n6];
            ++n6;
        }
    }

    void sendAndBindParametersInOneGo(int n) throws SQLException {
        jobTrace.debug("sendAndBindParametersInOneGo(ordinal=" + n + ")");
        this.setupBindings(n);
        this.rpc.cl.job_pset_one_go(this.hStmt, this.oneGoData, this.oneGoDataSize);
    }

    void sendAndUpdateColumnsInOneGo(int n) throws SQLException {
        jobTrace.debug("sendAndUpdateColumnsInOneGo(ordinal=" + n + ")");
        this.setupBindings(n);
        this.rpc.cl.job_ucs_one_go(this.hStmt, this.oneGoData, this.oneGoDataSize);
    }

    void copyBytes(int n, byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        while (n2 < byArray2.length) {
            byArray[n + n2] = byArray2[n2];
            ++n2;
        }
    }

    void sendAndBindParameter(int n, int n2, int n3, int n4, byte[] byArray, String string) throws SQLException {
        switch (n2) {
            case 4: {
                this.rpc.jdbc_setParam("PreparedStatement", "setInt", this.hStmt, (short)n, string, (short)4, (short)0);
                break;
            }
            case 8: {
                this.rpc.jdbc_setDouble("PreparedStatement", "setDouble", this.hStmt, (short)n, string);
                break;
            }
            default: {
                this.rpc.jdbc_setString("PreparedStatement", "setString", this.hStmt, (short)n, string);
            }
        }
    }

    void printParameters(int n) {
        int n2 = n - 1;
        int n3 = this.batchArrayCount[n2];
        String string = "";
        string = string + "batchArrayCount[setIndex]=" + this.batchArrayCount[n2] + "\n";
        int n4 = 0;
        while (n4 < n3) {
            string = string + "P[" + (n4 + 1) + "] ";
            string = string + this.toStringParameter(this.batchArrayIndex[n2][n4], this.batchArrayType[n2][n4], this.batchArrayParamType[n2][n4], this.batchArrayLength[n2][n4], this.batchArrayData[n2][n4], this.batchArrayStringData[n2][n4]);
            ++n4;
        }
    }

    public String toStringParameter(int n, int n2, int n3, int n4, byte[] byArray, String string) {
        String string2 = "";
        string2 = string2 + " Index=" + n;
        string2 = string2 + " SQL=" + n2;
        string2 = string2 + " PType=" + n3;
        string2 = string2 + " Length=" + n4;
        if (byArray != null) {
            string = new String(byArray);
        }
        string2 = string2 + " Data=" + string + "\n";
        return string2;
    }

    public int[] executeBatch() throws SQLException, BatchUpdateException {
        jobTrace.enter("BPS", "executeBatch setCount=" + this.setsCount);
        int[] nArray = new int[this.setsCount - 1];
        boolean bl = false;
        int n = 1;
        while (n < this.setsCount) {
            short s;
            jobTrace.debug("j=" + n);
            try {
                nArray[n - 1] = this.executeUpdateNoReset(n);
            }
            catch (SQLException sQLException) {
                nArray[n - 1] = -3;
                bl = true;
            }
            jobTrace.println("updateCounts[j-1]=" + nArray[n - 1] + " j=" + n);
            if (nArray[n - 1] == -1 && (s = this.rpc.jdbc_getColumnCount("", "", this.hStmt)) > 0) {
                throw new BatchUpdateException("Batched statement should be an update statement", nArray);
            }
            if (bl) {
                throw new BatchUpdateException("Batched statement generated one or more exceptions", nArray);
            }
            ++n;
        }
        return nArray;
    }

    public int executeUpdate(int n) throws SQLException {
        this.sendAndBindParametersInOneGo(n);
        this.resetBatch();
        this.rpc.Jsql_execute("PreparedStatement", "executeUpdate", this.hStmt);
        int n2 = (int)this.rpc.Jsql_row_count("", "", this.hStmt);
        return n2;
    }

    public int executeUpdateNoReset(int n) throws SQLException {
        this.sendAndBindParametersInOneGo(n);
        this.rpc.Jsql_execute("PreparedStatement", "executeUpdate", this.hStmt);
        int n2 = (int)this.rpc.Jsql_row_count("", "", this.hStmt);
        return n2;
    }

    public void executeQuery(int n) throws SQLException {
        this.sendAndBindParametersInOneGo(n);
        this.resetBatch();
        this.rpc.Jsql_execute("PreparedStatement", "executeUpdate", this.hStmt);
    }

    public void updateRow() throws SQLException {
        this.setupBindings(1);
        this.rpc.cl.job_ucs_one_go(this.hStmt, this.oneGoData, this.oneGoDataSize);
    }

    public void insertRow() throws SQLException {
        this.setupBindings(1);
        this.rpc.cl.job_ucs_one_go(this.hStmt, this.oneGoData, this.oneGoDataSize);
    }

    public void resetBatch() {
        this.currentParameterSet = 1;
        this.setsCount = 1;
        this.batchArrayCount[0] = 0;
    }

    public String int2hexString(int n) {
        String string = Integer.toString(n, 16).toUpperCase();
        switch (string.length()) {
            case 1: {
                string = "000" + string;
                break;
            }
            case 2: {
                string = "00" + string;
                break;
            }
            case 3: {
                string = "0" + string;
                break;
            }
        }
        return string;
    }

    public byte[] int2hexBytes(int n) {
        return this.int2hexString(n).getBytes();
    }

    public byte[] setTimestamp(Timestamp timestamp) {
        byte[] byArray = new byte[28];
        this.rpc.cl.packet.write4Bytes(timestamp.getYear(), 0, byArray);
        this.rpc.cl.packet.write4Bytes((long)timestamp.getMonth() + 1L, 4, byArray);
        this.rpc.cl.packet.write4Bytes(timestamp.getDate(), 8, byArray);
        this.rpc.cl.packet.write4Bytes(timestamp.getHours(), 12, byArray);
        this.rpc.cl.packet.write4Bytes(timestamp.getMinutes(), 16, byArray);
        this.rpc.cl.packet.write4Bytes(timestamp.getSeconds(), 20, byArray);
        this.rpc.cl.packet.write4Bytes(timestamp.getNanos(), 24, byArray);
        return byArray;
    }
}

