/*
 * Decompiled with CFR 0.152.
 */
package easysoft.sql;

import easysoft.sql.BPS;
import easysoft.sql.Bytes;
import easysoft.sql.jobConnection;
import easysoft.sql.jobDriver;
import easysoft.sql.jobResultSet;
import easysoft.sql.jobStatement;
import easysoft.sql.jobTrace;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class jobPreparedStatement2
extends jobStatement
implements PreparedStatement {
    ResultSetMetaData rsmd;
    public BPS bps;

    public void addBatch() throws SQLException {
        jobTrace.enter(this.o, "addBatch");
        this.bps.addBatch();
        jobTrace.returnVoid("addBatch");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            jobTrace.enter(this.o, "setCharacterStream(" + n + ", " + n2 + ")");
            if (this.rpc.cl.unicodeFlag == 0) {
                int n3;
                byte[] byArray = new byte[n2 + 1];
                int n4 = 0;
                while ((n3 = reader.read()) > -1) {
                    byte by = (byte)(n3 % 256);
                    byArray[n4++] = this.tub(by);
                }
                byArray[n4] = 0;
                this.setBytes(n, byArray);
            } else {
                int n5;
                byte[] byArray = new byte[2 * n2];
                int n6 = 0;
                while ((n5 = reader.read()) > -1) {
                    byte by = (byte)(n5 / 256);
                    byte by2 = (byte)(n5 % 256);
                    byArray[n6++] = this.tub(by2);
                    byArray[n6++] = this.tub(by);
                }
                this.setBytes(n, byArray);
            }
            jobTrace.returnVoid("setCharacterStream");
        }
        catch (IOException iOException) {
            throw new SQLException(jobDriver.errorPrefix + iOException.getMessage(), "HY000");
        }
    }

    byte tub(byte by) {
        return by < 0 ? (byte)(256 + by) : by;
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("SQL 32 Data types are not supported");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("SQL 3 Data types are not supported");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException("SQL 3 Data types are not supported");
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("Job2 setArray (int i, Array x) not implemented yet");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        jobTrace.enter(this.o, "getMetaData");
        if (this.rsmd == null) {
            ResultSet resultSet = (ResultSet)jobTrace.returnObject(new jobResultSet(this.rpc, this));
            this.rsmd = resultSet.getMetaData();
        }
        return this.rsmd;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public jobPreparedStatement2() throws SQLException {
        this.o = "PreparedStatement";
    }

    public jobPreparedStatement2(jobConnection jobConnection2, String string) throws SQLException {
        this.conn = jobConnection2;
        this.o = "PreparedStatement";
        this.rpc = jobConnection2.rpc;
        this.fetchSize = jobConnection2.fetchSize;
        this.resultSetType = 1003;
        if (jobConnection2.cl == null) {
            throw new SQLException("Connection is not available to create PreparedStatement");
        }
        this.hStmt = this.rpc.jdbc_prepareStatement("Connection", "prepareStatement", jobConnection2.jobHandle, string);
        if (jobConnection2.limit > 0) {
            this.setMaxRows(jobConnection2.limit);
        }
        this.bps = new BPS(this);
    }

    public jobPreparedStatement2(jobConnection jobConnection2, String string, int n, int n2) throws SQLException {
        super(jobConnection2, n, n2);
        this.o = "PreparedStatement";
        this.fetchSize = 0;
        if (n != 1003) {
            this.fetchSize = 0;
        }
        this.rpc.jdbc2_prepareStatement("Connection", "prepareStatement", this.hStmt, string);
        if (jobConnection2.limit > 0) {
            this.setMaxRows(jobConnection2.limit);
        }
        this.bps = new BPS(this);
    }

    public void clearParameters() throws SQLException {
        this.rpc.jdbc_clearParameters(this.o, "clearParameters", this.hStmt);
        this.bps.resetBatch();
        jobTrace.returnVoid();
    }

    public boolean execute() throws SQLException {
        int n = this.executeUpdate();
        if (n > 0) {
            return jobTrace.returnBool(false);
        }
        this.columnCount = this.rpc.jdbc_getColumnCount("", "", this.hStmt);
        if (this.columnCount > 0) {
            return jobTrace.returnBool(true);
        }
        return jobTrace.returnBool(false);
    }

    public ResultSet executeQuery() throws SQLException {
        this.closeResult();
        this.bps.executeQuery(1);
        ResultSet resultSet = (ResultSet)jobTrace.returnObject(new jobResultSet(this.rpc, this));
        this.rsmd = resultSet.getMetaData();
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        jobTrace.enter(this.o, "executeUpdate");
        this.updateCount = this.bps.executeUpdate(1);
        return jobTrace.returnInt("executeUpdate", (int)this.updateCount);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            jobTrace.enter(this.o, "setAsciiStream(" + n + ", " + inputStream + ", " + n2 + ")");
            inputStream.read(byArray, 0, n2);
            String string = new String(byArray);
            jobTrace.debug("data as string" + string + "|End of In STring!");
            jobTrace.debug("length: " + string.length());
            this.setBytes(n, byArray);
            jobTrace.returnVoid("setAsciiStream");
        }
        catch (IOException iOException) {
            throw new SQLException(jobDriver.errorPrefix + "setAsciiStream failed " + iOException.getMessage(), "HY000");
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        jobTrace.enter(this.o, "setBigDecimal", "index=" + n + "x=" + bigDecimal);
        this.bps.setParam(n, 1, bigDecimal.toString().getBytes());
        jobTrace.returnVoid("setBigDecimal");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        boolean bl = false;
        boolean bl2 = false;
        try {
            jobTrace.enter(this.o, "setBinaryStream(" + n + ", " + inputStream + ")");
            inputStream.read(byArray, 0, n2);
            this.setBytes(n, byArray);
            jobTrace.returnVoid();
        }
        catch (IOException iOException) {
            throw new SQLException(jobDriver.errorPrefix + "setBinaryStream failed: " + iOException.getMessage(), "HY000");
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        jobTrace.enter(this.o, "setBoolean", "index=" + n + ", x=" + bl);
        this.bps.setParam(n, -7, new Integer(n2).toString().getBytes());
        jobTrace.returnVoid("setBoolean");
    }

    public void setByte(int n, byte by) throws SQLException {
        jobTrace.enter(this.o, "setByte", "index=" + n + ", x=" + by);
        this.bps.setParam(n, -6, new Integer(by).toString().getBytes());
        jobTrace.returnVoid("setByte");
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            jobTrace.enter(this.o, "setBytes(" + n + ", " + byArray + ")");
            int n2 = 0;
            while (n2 < byArray.length) {
                jobTrace.print(new Byte(byArray[n2]).toString() + "|");
                ++n2;
            }
            jobTrace.println("\nEnd of Bytes\n");
            this.bps.setParam(n, -2, byArray);
            jobTrace.returnVoid("setBytes");
        }
        catch (Exception exception) {
            throw new SQLException(jobDriver.errorPrefix + "PreparedStatement.setBytes(" + byArray + ")  failed: " + exception.getMessage(), "HY000");
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        byte[] byArray = new byte[12];
        jobTrace.enter(this.o, "setDate", "index=" + n + "x=" + date);
        this.rpc.cl.packet.write4Bytes(date.getYear(), 0, byArray);
        this.rpc.cl.packet.write4Bytes((long)date.getMonth() + 1L, 4, byArray);
        this.rpc.cl.packet.write4Bytes(date.getDate(), 8, byArray);
        this.bps.setParam(n, 91, byArray);
        jobTrace.returnVoid("setDate");
    }

    public void setDouble(int n, double d) throws SQLException {
        jobTrace.enter(this.o, "setDouble", "index=" + n + "x=" + d);
        this.bps.setParam(n, 1, new Double(d).toString().getBytes());
        jobTrace.returnVoid("setDouble");
    }

    public void setFloat(int n, float f) throws SQLException {
        jobTrace.enter(this.o, "setFloat", "index=" + n + ", " + "x=" + f);
        this.bps.setParam(n, 1, new Float(f).toString().getBytes());
        jobTrace.returnVoid("setFloat");
    }

    public void setInt(int n, int n2) throws SQLException {
        jobTrace.enter(this.o, "setInt", "index=" + n + ", " + "x=" + n2);
        this.bps.setParam(n, 1, new Integer(n2).toString().getBytes());
        jobTrace.returnVoid("setInt");
    }

    public void setLong(int n, long l) throws SQLException {
        jobTrace.enter(this.o, "setLong", "index=" + n + "x=" + l);
        this.bps.setParam(n, 1, new Long(l).toString().getBytes());
        jobTrace.returnVoid("setLong");
    }

    public void setNull(int n, int n2) {
        jobTrace.enter(this.o, "setNull", "index=" + n + "sqlType=" + n2);
        byte[] byArray = new byte[4];
        this.bps.setParam(n, 0, this.rpc.cl.packet.write4Bytes(n2, 0, byArray));
        jobTrace.returnVoid("setNull");
    }

    public void setNullOrig(int n, int n2) throws SQLException {
        if (n2 == 91) {
            n2 = 93;
        }
        this.rpc.jdbc_setNull(this.o, "setNull", this.hStmt, (short)n, (short)n2);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new SQLException("Job  setNull (int parameIndex, int sqlType, String typeName) not implemented yet");
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Bytes) {
            this.setBytes(n, ((Bytes)object).getBytes());
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
        } else if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
        } else if (object instanceof Ref) {
            this.setRef(n, (Ref)object);
        } else if (object instanceof Array) {
            this.setArray(n, (Array)object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else {
            this.setObject(n, object, 1111);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        jobTrace.enter(this.o, "setObject(" + n + ", " + object + ", " + n2 + ")");
        this.setObject(n, object, n2, 0);
        jobTrace.returnVoid();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            jobTrace.enter(this.o, "setObject(" + n + ", " + object + ", " + n2 + ", " + n3 + ")");
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                if (bl.booleanValue()) {
                    this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, "1", (short)n2, (short)n3);
                } else {
                    this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, "0", (short)n2, (short)n3);
                }
            } else if (object instanceof Float) {
                Float f = (Float)object;
                switch (n2) {
                    case 4: {
                        Integer n4 = new Integer(f.intValue());
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, n4.toString(), (short)n2, (short)n3);
                        break;
                    }
                    case -5: 
                    case 2: {
                        BigDecimal bigDecimal = new BigDecimal(f.toString());
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, bigDecimal.toString(), (short)n2, (short)n3);
                        break;
                    }
                    default: {
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, f.toString(), (short)n2, (short)n3);
                        break;
                    }
                }
            } else if (object instanceof Double) {
                Double d = (Double)object;
                switch (n2) {
                    case 4: {
                        Integer n5 = new Integer(d.intValue());
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, n5.toString(), (short)n2, (short)n3);
                        break;
                    }
                    case -5: 
                    case 2: {
                        BigDecimal bigDecimal = new BigDecimal(d.toString());
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, bigDecimal.toString(), (short)n2, (short)n3);
                        break;
                    }
                    default: {
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, d.toString(), (short)n2, (short)n3);
                        break;
                    }
                }
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                String string = new String(byArray);
                this.rpc.jdbc_setBytes(this.o, "setObject", this.hStmt, (short)n, string);
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                switch (n2) {
                    case 92: {
                        String string = "";
                        String string2 = "00" + timestamp.getHours();
                        string = string + string2.substring(string2.length() - 2, string2.length());
                        string = string + ":";
                        string2 = "00" + timestamp.getMinutes();
                        string = string + string2.substring(string2.length() - 2, string2.length());
                        string = string + ":";
                        string2 = "00" + timestamp.getSeconds();
                        string = string + string2.substring(string2.length() - 2, string2.length());
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, string, (short)n2, (short)n3);
                        break;
                    }
                    default: {
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, object.toString(), (short)n2, (short)n3);
                        break;
                    }
                }
            } else if (object instanceof Time) {
                Time time = (Time)object;
                switch (n2) {
                    case 93: {
                        String string = "";
                        String string3 = "00" + time.getHours();
                        string = string + string3.substring(string3.length() - 2, string3.length());
                        string = string + ":";
                        string3 = "00" + time.getMinutes();
                        string = string + string3.substring(string3.length() - 2, string3.length());
                        string = string + ":";
                        string3 = "00" + time.getSeconds();
                        string = string + string3.substring(string3.length() - 2, string3.length());
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, string, (short)92, (short)n3);
                        break;
                    }
                    default: {
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, object.toString(), (short)n2, (short)n3);
                        break;
                    }
                }
            } else if (object instanceof Date) {
                Date date = (Date)object;
                switch (n2) {
                    case 93: {
                        String string = "";
                        String string4 = "0000" + (date.getYear() + 1900);
                        string = string + string4.substring(string4.length() - 4, string4.length());
                        string = string + "-";
                        string4 = "00" + (date.getMonth() + 1);
                        string = string + string4.substring(string4.length() - 2, string4.length());
                        string = string + "-";
                        string4 = "00" + date.getDate();
                        string = string + string4.substring(string4.length() - 2, string4.length());
                        string = string + " 00:00:00.0";
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, string, (short)93, (short)n3);
                        break;
                    }
                    default: {
                        this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, object.toString(), (short)n2, (short)n3);
                        break;
                    }
                }
            } else {
                this.rpc.jdbc_setParam(this.o, "setObject", this.hStmt, (short)n, object.toString(), (short)n2, (short)n3);
            }
            jobTrace.returnVoid("setObject");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(jobDriver.errorPrefix + "Job setObject failed: NumberFormatException: " + numberFormatException.getMessage(), "HY000");
        }
        catch (Exception exception) {
            throw new SQLException(jobDriver.errorPrefix + "Job setObject failed: " + exception.getMessage(), "HY000");
        }
    }

    public void setShort(int n, short s) throws SQLException {
        jobTrace.enter(this.o, "setShort", "index=" + n + ", " + "x=" + s);
        this.bps.setParam(n, 1, new Short(s).toString().getBytes());
        jobTrace.returnVoid("setShort");
    }

    public void setString(int n, String string) throws SQLException {
        jobTrace.enter(this.o, "setString", "index=" + n + ", " + "x=" + string);
        if (string == null) {
            this.setNull(n, 1);
            return;
        }
        jobTrace.println("unicodeFlag is=" + this.conn.unicodeFlag);
        if (this.conn.unicodeFlag != 0 && this.isUnicode(string)) {
            StringReader stringReader = new StringReader(string);
            this.setCharacterStream(n, (Reader)stringReader, string.length());
        } else {
            this.bps.setParam(n, 1, string.getBytes());
        }
        jobTrace.returnVoid("setString");
    }

    public void setStringOrig(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 1);
            return;
        }
        if (this.conn.unicodeFlag != 0 && this.isUnicode(string)) {
            StringReader stringReader = new StringReader(string);
            this.setCharacterStream(n, (Reader)stringReader, string.length());
        } else {
            this.rpc.jdbc_setString(this.o, "setString", this.hStmt, (short)n, string);
        }
    }

    boolean isUnicode(String string) {
        jobTrace.enter(this.o, "isUnicode(" + string + ")");
        int n = 12;
        if (string.length() <= n) {
            n = string.length();
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] > '\u0100') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setTime(int n, Time time) throws SQLException {
        byte[] byArray = new byte[12];
        jobTrace.enter(this.o, "setTime", "index=" + n + "x=" + time);
        this.rpc.cl.packet.write4Bytes(time.getHours(), 0, byArray);
        this.rpc.cl.packet.write4Bytes(time.getMinutes(), 4, byArray);
        this.rpc.cl.packet.write4Bytes(time.getSeconds(), 8, byArray);
        this.bps.setParam(n, 92, byArray);
        jobTrace.returnVoid("setTime");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        jobTrace.enter(this.o, "setTimeStamp", "index=" + n + "x=" + timestamp);
        byte[] byArray = this.bps.setTimestamp(timestamp);
        this.bps.setParam(n, 93, byArray);
        jobTrace.returnVoid("setTimeStamp");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            int n3;
            jobTrace.enter(this.o, "setUnicodeStream(" + n + ", " + n2 + ")");
            byte[] byArray = new byte[2 * n2];
            int n4 = 0;
            while ((n3 = inputStream.read()) > -1) {
                byte by = (byte)(n3 / 256);
                byte by2 = (byte)(n3 % 256);
                byArray[n4++] = by;
                byArray[n4++] = by2;
            }
            this.rpc.cl.setLOB(this.hStmt, (short)n, byArray, -4);
            jobTrace.returnVoid();
        }
        catch (Exception exception) {
            throw new SQLException(jobDriver.errorPrefix + "setUnicodeStream failed: " + exception.getMessage(), "HY000");
        }
    }

    public int[] executeBatch() throws SQLException {
        jobTrace.enter(this.o, "executeBatch()");
        return this.bps.executeBatch();
    }

    public void clearBatch() throws SQLException {
        this.bps.resetBatch();
    }
}

