/*
 * Decompiled with CFR 0.152.
 */
package easysoft.sql;

import easysoft.rpc.Stub;
import easysoft.sql.BPS;
import easysoft.sql.SBFM;
import easysoft.sql.jobColumn;
import easysoft.sql.jobDriver;
import easysoft.sql.jobResultSetMetaData;
import easysoft.sql.jobRow;
import easysoft.sql.jobStatement;
import easysoft.sql.jobTrace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class jobResultSet
implements ResultSet {
    Stub rpc;
    jobStatement stmt;
    public long hStmt;
    boolean isClosed;
    int numCols;
    public int fetchSize;
    SBFM sbfm;
    Hashtable columnNames;
    jobColumn[] columnInfoArray;
    String[] columnStringArray;
    boolean[] isUnicode;
    String o;
    int currentRow;
    int insertRow;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public int CONCUR_READ_ONLY;
    public int CONCUR_UPDATABLE;
    boolean onInsertRow;
    public jobRow rowData;
    boolean rowUpdated;
    public int fetchDirection;
    DatabaseMetaData dbmd;
    ResultSetMetaData rsmd;
    public byte[] data;
    public short unicodeFlag;
    public BPS bps;
    int rowStatus;

    public jobResultSet() {
        this.hStmt = 0L;
        this.isClosed = false;
        this.numCols = 0;
        this.fetchSize = -1;
        this.sbfm = null;
        this.o = "ResultSet";
        this.currentRow = 0;
        this.insertRow = 0;
        this.CONCUR_READ_ONLY = 1007;
        this.CONCUR_UPDATABLE = 1008;
        this.onInsertRow = false;
        this.rowUpdated = false;
        this.fetchDirection = 1000;
        this.rsmd = null;
        this.unicodeFlag = 0;
        this.bps = null;
        this.rowStatus = 0;
    }

    public jobResultSet(Stub stub, jobStatement jobStatement2) throws SQLException {
        block22: {
            this.hStmt = 0L;
            this.isClosed = false;
            this.numCols = 0;
            this.fetchSize = -1;
            this.sbfm = null;
            this.o = "ResultSet";
            this.currentRow = 0;
            this.insertRow = 0;
            this.CONCUR_READ_ONLY = 1007;
            this.CONCUR_UPDATABLE = 1008;
            this.onInsertRow = false;
            this.rowUpdated = false;
            this.fetchDirection = 1000;
            this.rsmd = null;
            this.unicodeFlag = 0;
            this.bps = null;
            this.rowStatus = 0;
            this.stmt = jobStatement2;
            this.hStmt = jobStatement2.hStmt;
            this.rpc = stub;
            this.columnNames = new Hashtable();
            this.fetchSize = jobStatement2.fetchSize;
            this.dbmd = jobStatement2.conn.getMetaData();
            this.unicodeFlag = jobStatement2.conn.unicodeFlag;
            if (jobStatement2.conn.dbProductName == null) {
                this.dbmd = jobStatement2.conn.getMetaData();
                jobStatement2.conn.dbProductName = this.dbmd.getDatabaseProductName();
            }
            if (jobStatement2.conn.dbProductName.equals("ACCESS") && this.unicodeFlag != 0) {
                this.unicodeFlag = (short)2;
            }
            try {
                short s;
                short s2;
                short s3;
                short s4;
                String string;
                String string2;
                Object object;
                int n;
                jobStatement2.columnCount = this.numCols = (int)stub.jdbc_getColumnCount("", "", this.hStmt);
                if (this.numCols <= 0) break block22;
                this.reset_row();
                this.columnInfoArray = new jobColumn[this.numCols + 1];
                if (this.fetchSize >= 0) {
                    n = 1;
                    while (n <= this.numCols) {
                        jobColumn jobColumn2;
                        object = stub.job_getColumnInfo("", "", this.hStmt, (short)n);
                        string2 = (String)object[1];
                        string = (String)object[2];
                        s4 = (Short)object[3];
                        s3 = (Short)object[4];
                        s2 = (Short)object[5];
                        s = (Short)object[6];
                        this.columnInfoArray[n] = jobColumn2 = new jobColumn(n, string2, string, s4, s3, s2, s);
                        if (this.columnNames.containsKey(string2)) {
                            jobTrace.debug("Column : " + string2 + "is already in the result set");
                        } else {
                            this.columnNames.put(string2, jobColumn2);
                        }
                        ++n;
                    }
                } else {
                    this.sbfm = new SBFM(stub, jobStatement2, this);
                    this.sbfm.cursor = 0;
                    this.sbfm.rowCountTotal = this.numCols;
                    n = this.sbfm.nextColumn;
                    while (n < this.sbfm.rowCountTotal + 1) {
                        jobTrace.debug("NEXTCOLUMN: " + n + "  " + this.sbfm.nextColumn);
                        this.reset_row(6);
                        this.sbfm.next();
                        string2 = this.getString(1);
                        string = this.getString(2);
                        s4 = this.getShort(3);
                        s3 = this.getShort(4);
                        s2 = this.getShort(5);
                        s = this.getShort(6);
                        this.columnInfoArray[n] = object = new jobColumn(n, string2, string, s4, s3, s2, s);
                        if (this.columnNames.containsKey(string2)) {
                            jobTrace.debug("Column : " + string2 + "is already in the result set");
                        } else {
                            this.columnNames.put(string2, object);
                        }
                        ++n;
                    }
                }
                if (this.fetchSize == -1) {
                    this.sbfm = new SBFM(stub, jobStatement2, this, this.numCols);
                    this.reset_row();
                }
                if (this.fetchSize > 0) {
                    throw new SQLException("fetchSize must be 0 or -1");
                }
                this.rsmd = this.getMetaData();
                n = this.rsmd.getColumnCount();
                this.isUnicode = new boolean[n];
                int n2 = 0;
                while (n2 < n) {
                    if (this.unicodeFlag == 0) {
                        this.isUnicode[n2] = false;
                    } else {
                        switch (this.rsmd.getColumnType(n2 + 1)) {
                            case -1: 
                            case 1: 
                            case 12: {
                                if (this.unicodeFlag == 2) {
                                    this.isUnicode[n2] = true;
                                    break;
                                }
                                this.isUnicode[n2] = false;
                                break;
                            }
                            case -10: 
                            case -9: 
                            case -8: {
                                this.isUnicode[n2] = true;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                throw jobDriver.extendChain(sQLException, "ResultSet creation failed" + sQLException.getMessage());
            }
        }
    }

    public boolean absolute(int n) throws SQLException {
        if (this.stmt.resultSetType == 1003) {
            throw new SQLException("absolute( int row ) called on FORWARD_ONLY result set", "HY000");
        }
        this.reset_row();
        if (n < 0) {
            boolean bl = this.last();
            if (bl && (bl = this.returnExtendedFetch(this.rpc.sql_ExtendedFetch(this.o, "absolute", this.hStmt, (short)5, n), "absolute"))) {
                this.currentRow += ++n;
            }
            return bl;
        }
        if (n > 0) {
            boolean bl = this.returnExtendedFetch(this.rpc.sql_ExtendedFetch(this.o, "absolute", this.hStmt, (short)5, n), "absolute");
            if (bl) {
                this.currentRow = n;
            }
            return bl;
        }
        throw new SQLException("absolute( 0 ) called", "HY000");
    }

    public void afterLast() throws SQLException {
        if (this.stmt.resultSetType == 1003) {
            throw new SQLException("afterLast() called on FORWARD_ONLY result set", "HY000");
        }
        String string = "afterLast";
        jobTrace.enter(this.o, string);
        this.absolute(-1);
        this.relative(1);
        jobTrace.returnVoid(string);
    }

    byte[] appendBuffer(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        if (this.unicodeFlag != 0 && n != -2) {
            --n2;
            --n2;
        }
        int n4 = n2 + n3;
        byte[] byArray3 = new byte[n4];
        int n5 = 0;
        while (n5 < n2) {
            byArray3[n5] = byArray[n5];
            ++n5;
        }
        int n6 = n2;
        while (n6 < n4) {
            byArray3[n6] = byArray2[n6 - n2];
            ++n6;
        }
        return byArray3;
    }

    public void beforeFirst() throws SQLException {
        if (this.stmt.resultSetType == 1003) {
            throw new SQLException("beforeFirst() called on FORWARD_ONLY result set", "HY000");
        }
        jobTrace.enter(this.o, "beforeFirst");
        this.absolute(1);
        jobTrace.returnBool("beforeFirst", this.previous());
    }

    public void cancelRowUpdates() throws SQLException {
        this.rowData = null;
        this.rowData = new jobRow(this);
    }

    public void clearWarnings() throws SQLException {
        this.rpc.jdbc_clearWarnings(this.o, "clearWarnings", this.rpc.cl.jobHandle);
    }

    public void close() throws SQLException {
        int n;
        if (this.isClosed) {
            return;
        }
        if (this.stmt.hStmt != 0L) {
            this.rpc.jdbc_closeResultSetX(this.o, "close", this.hStmt);
        }
        this.numCols = -1;
        this.columnNames = null;
        if (this.columnInfoArray != null) {
            n = 0;
            while (n < this.columnInfoArray.length) {
                this.columnInfoArray[n] = null;
                ++n;
            }
        }
        this.columnInfoArray = null;
        if (this.columnStringArray != null) {
            n = 0;
            while (n < this.columnStringArray.length) {
                this.columnStringArray[n] = null;
                ++n;
            }
        }
        this.columnStringArray = null;
        this.sbfm = null;
        this.isUnicode = null;
        this.rowData = null;
        this.dbmd = null;
        this.rsmd = null;
        this.isClosed = true;
        this.stmt.result = null;
    }

    public void deleteRow() throws SQLException {
        this.rowStatus = this.rpc.sql_SetPos(this.o, "deleteRow", this.hStmt, 0L, (short)3);
    }

    public int findColumn(String string) throws SQLException {
        jobTrace.enter(this.o, "findColumn", "" + string);
        jobColumn jobColumn2 = (jobColumn)this.columnNames.get(string);
        if (jobColumn2 == null) {
            jobColumn2 = (jobColumn)this.columnNames.get(string.toLowerCase());
        }
        if (jobColumn2 == null) {
            throw new SQLException("Column name: " + string + " cannot be found in result set ");
        }
        return jobTrace.returnInt(jobColumn2.getIndex());
    }

    public boolean first() throws SQLException {
        if (this.stmt.resultSetType == 1003) {
            throw new SQLException("first() called on FORWARD_ONLY result set", "HY000");
        }
        this.reset_row();
        jobTrace.enter(this.o, "first()");
        return jobTrace.returnBool(this.absolute(1));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        jobTrace.enter(this.o, "getAsciiStream(" + n + ")");
        String string = "error";
        string = this.getString(n);
        if (string == null) {
            return null;
        }
        return (InputStream)jobTrace.returnObject(new StringBufferInputStream(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        jobTrace.enter(this.o, "getAsciiStream(" + string + ")");
        return (InputStream)jobTrace.returnObject(this.getAsciiStream(this.findColumn(string)));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        jobTrace.enter(this.o, "getBigDecimal(" + n + ")");
        String string = "error";
        try {
            string = this.getString(n);
            if (string == null || string.equals("")) {
                return (BigDecimal)jobTrace.returnObject(null);
            }
            return (BigDecimal)jobTrace.returnObject(new BigDecimal(string));
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, string + " cannot be read as a BigDecimal");
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        jobTrace.enter(this.o, "getBigDecimal(" + n + ", " + n2 + ")");
        return (BigDecimal)jobTrace.returnObject(this.getBigDecimal(n));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        jobTrace.enter(this.o, "getBigDecimal(" + string + ", " + n + ")");
        return (BigDecimal)jobTrace.returnObject(this.getBigDecimal(string));
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            return new ByteArrayInputStream(this.getBytes(n));
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "Column " + n + " cannot be read as a byte array  stream");
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        jobTrace.enter(this.o, "getBoolean(" + n + ")");
        String string = "error";
        try {
            string = this.getString(n);
            if (string == null) {
                return jobTrace.returnBool(false);
            }
            if ((string = string.trim()).equals("")) {
                return jobTrace.returnBool(false);
            }
            if (string.equals("0")) {
                return jobTrace.returnBool(false);
            }
            if (string.equals("N")) {
                return jobTrace.returnBool(false);
            }
            if (string.equals("n")) {
                return jobTrace.returnBool(false);
            }
            if (string.equals("true")) {
                return jobTrace.returnBool(true);
            }
            if (string.equals("false")) {
                return jobTrace.returnBool(false);
            }
            if (string.length() >= 2 && string.substring(0, 2).equals(".0")) {
                return false;
            }
            if (string.length() >= 3 && string.substring(0, 3).equals("0.0")) {
                return false;
            }
            if (string.length() >= 3 && string.substring(0, 3).equals("1.0")) {
                return true;
            }
            int n2 = Integer.valueOf(string.trim());
            if (n2 == 0) {
                return false;
            }
            return jobTrace.returnBool(true);
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, string + " cannot be read as a boolean" + sQLException.getMessage() + sQLException.getSQLState());
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        jobTrace.enter(this.o, "getByte(" + n + ")");
        String string = "error";
        try {
            string = this.getString(n);
            if (string == null || string.equals("")) {
                return (byte)jobTrace.returnInt(0);
            }
            return (byte)jobTrace.returnInt(Integer.valueOf(string));
        }
        catch (Exception exception) {
            try {
                return (byte)jobTrace.returnInt(Double.valueOf(string.trim()).intValue());
            }
            catch (Exception exception2) {
                throw new SQLException(string + " cannot be read as a byte " + exception.getMessage(), "HY000");
            }
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        jobTrace.enter(this.o, "getBytes(" + n + ")");
        try {
            if (this.sbfm != null) {
                byte[] byArray = this.sbfm.getData(n, (short)-2);
                if (this.wasNull()) {
                    return null;
                }
                return byArray;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "Column " + n + " cannot be read as an array of bytes");
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        jobTrace.enter(this.o, "getCharacterStream(" + n + ")");
        String string = "error";
        try {
            string = this.getString(n);
            if (string == null) {
                return null;
            }
            return new StringReader(string);
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "column: " + n + " cannot be read as a characterStram  stream");
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        jobTrace.enter(this.o, "getConcurrency()");
        return jobTrace.returnInt(this.stmt.resultSetConcurrency);
    }

    public String getCursorName() throws SQLException {
        return this.rpc.Jsql_get_cursor_name(this.o, "getCursorName", this.hStmt);
    }

    public synchronized byte[] getData(int n, short s) throws SQLException {
        long l = 4000L;
        this.data = new byte[0];
        if (this.unicodeFlag == 2 || this.unicodeFlag != 0 && s == -8) {
            l = 2000L;
        }
        if (this.rpc.cl.TRACING) {
            jobTrace.debug("===> getData 0:" + n + " 1: " + s);
        }
        try {
            boolean bl;
            Object[] objectArray = this.rpc.cl.getDataXLOK(this.hStmt, s, (short)n, l);
            jobTrace.debug("getDataXLOL");
            this.data = (byte[])objectArray[0];
            long l2 = (Long)objectArray[1];
            jobTrace.debug("available Length: " + l2);
            if (l2 < l) {
                if (this.rpc.cl.TRACING) {
                    String string = new String(this.data);
                    jobTrace.debug("<== |" + string + "|==>");
                }
                return this.data;
            }
            do {
                if (this.rpc.cl.TRACING) {
                    jobTrace.debug("Available: " + l2 + "chunkSize: " + l + "\ndata: ");
                }
                int n2 = 2;
                if (this.unicodeFlag != 0) {
                    n2 = 4;
                }
                l = l2 + (long)n2 - l;
                if ((this.unicodeFlag == 2 || this.unicodeFlag != 0 && s == -8) && l > 2000L) {
                    l = 2000L;
                }
                if (l > 4000L) {
                    l = 4000L;
                }
                bl = (l2 = ((Long)(objectArray = this.rpc.cl.getDataXLOK(this.hStmt, s, (short)n, l))[1]).longValue()) > l + 1L;
                this.data = this.appendBuffer(this.data, (byte[])objectArray[0], s);
                jobTrace.debug("moreAvailable: " + bl);
            } while (bl);
            return this.data;
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "ResultSet.getData(" + n + ") failed");
        }
    }

    public Date getDate(int n) throws SQLException {
        jobTrace.enter(this.o, "getDate(" + n + ")");
        String string = this.getString(n);
        if (string == null || string.equals("")) {
            return null;
        }
        if (this.wasNull()) {
            return null;
        }
        Integer n2 = new Integer(string.substring(0, 4));
        Integer n3 = new Integer(string.substring(5, 7));
        Integer n4 = new Integer(string.substring(8, 10));
        return (Date)jobTrace.returnObject(new Date(n2 - 1900, n3 - 1, n4));
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("SQL 3 Data types are not supported");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("SQL 3 Data Types are not supported");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("Job2 getBlob(int i)  not implemented yet");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("CLOBs are  not supported");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("SQL 3 Datatype ARRAY is not supported");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("SQL 3 Datatype JAVA_OBJECT is not supported   not implemented yet");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("SQL 3 Data types are not supported");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("SQL 3 Data types are not supported");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("SQL 3 Data types are not supported");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("SQL 3 Data types are not supported");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        jobTrace.enter(this.o, "getDate(" + n + ")");
        Date date = this.getDate(n);
        if (date == null) {
            return date;
        }
        long l = date.getTime();
        calendar.setTime(new Date(l));
        return (Date)jobTrace.returnObject(new Date(calendar.getTime().getTime()));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        String string = "getDouble";
        jobTrace.enter(this.o, "getDouble", "" + n);
        String string2 = "error";
        try {
            string2 = this.getString(n);
            if (string2 == null || string2.equals("")) {
                return jobTrace.returnDouble(string, 0.0);
            }
            return jobTrace.returnDouble(string, Double.valueOf(string2));
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "data: " + string2 + " cannot be read as a double");
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        jobTrace.enter(this.o, "getFetchDirection");
        return jobTrace.returnInt(this.fetchDirection);
    }

    public int getFetchSize() throws SQLException {
        jobTrace.enter(this.o, "getFetchSize");
        if (this.fetchSize == -1) {
            return jobTrace.returnInt(0);
        }
        return jobTrace.returnInt(this.fetchSize);
    }

    public float getFloat(int n) throws SQLException {
        jobTrace.enter(this.o, "getFloat(" + n + ")");
        String string = "error";
        try {
            string = this.getString(n);
            if (string == null || string.equals("")) {
                return jobTrace.returnFloat("getFloat", 0.0f);
            }
            if (string.length() >= 2 && string.substring(0, 2).equals(".0")) {
                string = "0" + string;
            }
            return jobTrace.returnFloat("getFloat", Float.valueOf(string).floatValue());
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, string + " cannot be read as a float");
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        jobTrace.enter(this.o, "getInt", "" + n);
        String string = "error";
        try {
            string = this.getString(n);
            if (string == null || string.equals("")) {
                return 0;
            }
            return jobTrace.returnInt(Integer.valueOf(string.trim()));
        }
        catch (Exception exception) {
            try {
                return jobTrace.returnInt((int)Double.valueOf(string).doubleValue());
            }
            catch (Exception exception2) {
                throw new SQLException(jobDriver.errorPrefix + string + " cannot be read as an int " + exception2.getMessage(), "HYOOO");
            }
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        jobTrace.enter(this.o, "getLong(" + n + ")");
        String string = "error";
        try {
            string = this.getString(n);
            if (string == null || string.equals("")) {
                return 0L;
            }
            try {
                return jobTrace.returnLong(Long.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                return jobTrace.returnLong(Double.valueOf(string).longValue());
            }
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "data: " + string + " cannot be read as a long");
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.numCols == -1) {
            throw new SQLException("Result set is not valid", "S1010");
        }
        jobTrace.enter(this.o, "getMetaData");
        if (this.rsmd == null) {
            this.rsmd = (ResultSetMetaData)jobTrace.returnObject(new jobResultSetMetaData(this.rpc, this.columnNames, this.columnInfoArray, this.hStmt));
        }
        return this.rsmd;
    }

    public Object getObject(int n) throws SQLException {
        return this.getObject(n, this.columnInfoArray[n].getType());
    }

    public Object getObject(int n, int n2) throws SQLException {
        jobTrace.enter(this.o, "getObject(" + n + ", " + n2 + ")");
        try {
            switch (n2) {
                case -7: {
                    return jobTrace.returnObject(new Boolean(this.getBoolean(n)));
                }
                case -6: {
                    int n3 = this.getInt(n);
                    if (0 == n3 && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return jobTrace.returnObject(new Integer(n3));
                }
                case 5: {
                    short s = this.getShort(n);
                    if (0 == s && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return jobTrace.returnObject(new Integer(s));
                }
                case 4: {
                    int n4 = this.getInt(n);
                    if (0 == n4 && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return jobTrace.returnObject(new Integer(n4));
                }
                case -5: {
                    long l = this.getLong(n);
                    if (0L == l && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return jobTrace.returnObject(new Long(l));
                }
                case 7: {
                    double d = this.getFloat(n);
                    if (0.0 == d && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return new Float(d);
                }
                case 6: 
                case 8: {
                    double d = this.getDouble(n);
                    if (0.0 == d && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return new Double(d);
                }
                case 2: {
                    return jobTrace.returnObject(this.getBigDecimal(n));
                }
                case 3: {
                    return jobTrace.returnObject(this.getBigDecimal(n));
                }
                case 1: {
                    String string = this.getString(n);
                    if (string == null) {
                        return jobTrace.returnObject(null);
                    }
                    if (string.equals("") && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return jobTrace.returnObject(string);
                }
                case 12: {
                    String string = this.getString(n);
                    if (string == null) {
                        return jobTrace.returnObject(null);
                    }
                    if (string.equals("") && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return jobTrace.returnObject(string);
                }
                case -10: 
                case -9: 
                case -1: {
                    String string = this.getString(n);
                    if (string == null) {
                        return jobTrace.returnObject(null);
                    }
                    if (string.equals("") && this.wasNull()) {
                        return jobTrace.returnObject(null);
                    }
                    return jobTrace.returnObject(string);
                }
                case 91: {
                    return jobTrace.returnObject(this.getDate(n));
                }
                case 92: {
                    return jobTrace.returnObject(this.getTime(n));
                }
                case 93: {
                    return jobTrace.returnObject(this.getTimestamp(n));
                }
                case -2: {
                    return jobTrace.returnObject(this.getBytes(n));
                }
                case -3: {
                    return jobTrace.returnObject(this.getBytes(n));
                }
                case -4: {
                    return jobTrace.returnObject(this.getBytes(n));
                }
            }
            return jobTrace.returnObject(null);
        }
        catch (SQLException sQLException) {
            jobTrace.debug(sQLException.getMessage());
            throw jobDriver.extendChain(sQLException, "getObject Failed" + sQLException.getMessage());
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int getRow() throws SQLException {
        return this.currentRow;
    }

    public short getShort(int n) throws SQLException {
        jobTrace.enter(this.o, "getShort", "" + n);
        return (short)jobTrace.returnInt(this.getInt(n));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        return (Statement)jobTrace.returnObject(this.stmt);
    }

    public String getString(int n) throws SQLException {
        jobTrace.enter(this.o, "getString", "" + n);
        if (this.columnStringArray[n] != null) {
            return this.columnStringArray[n];
        }
        try {
            String string;
            if (this.sbfm != null) {
                if (!this.sbfm.columnInfo && this.getMetaData().getColumnType(n) <= -8 && this.getMetaData().getColumnType(n) >= -10 && this.unicodeFlag != 0) {
                    jobTrace.debug("calling patchUniode");
                    string = this.patchUnicode(this.sbfm.getData(n, (short)-2));
                } else {
                    string = !this.sbfm.columnInfo && this.unicodeFlag == 2 ? this.patchUnicode(this.sbfm.getData(n, (short)1)) : new String(this.sbfm.getData(n, (short)1));
                }
            } else {
                if (this.unicodeFlag == 0) {
                    this.columnStringArray[n] = new String(this.getData(n, (short)1));
                    return this.columnStringArray[n];
                }
                int n2 = this.getMetaData().getColumnType(n);
                switch (n2) {
                    case -10: 
                    case -9: 
                    case -8: {
                        string = this.patchUnicode(this.getData(n, (short)-8));
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] byArray = this.getData(n, (short)-2);
                        string = new String(byArray);
                    }
                    default: {
                        byte[] byArray = this.getData(n, (short)1);
                        string = this.unicodeFlag == 2 ? new String(this.patchUnicode(byArray)) : new String(byArray);
                    }
                }
            }
            if (string == null) {
                this.columnStringArray[n] = null;
                return jobTrace.returnString(null);
            }
            if (string.equals("") && this.wasNull()) {
                string = null;
            }
            this.columnStringArray[n] = string;
            return jobTrace.returnString("getString", string);
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "ResultSet.getString(" + n + ") failed");
        }
    }

    public String patchUnicode(byte[] byArray) {
        if (this.unicodeFlag == 0) {
            return new String(byArray);
        }
        return this.doPatchUnicode(byArray);
    }

    byte[] swapHighLowBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 1];
            byArray[n + 1] = by;
            n += 2;
        }
        return byArray;
    }

    String doPatchUnicode(byte[] byArray) {
        jobTrace.debug("doPatchUnicode(b.length=" + byArray.length);
        boolean bl = true;
        int n = byArray.length;
        int n2 = n % 2;
        if (n % 2 == 1) {
            --n;
        }
        char[] cArray = new char[n / 2];
        int n3 = 0;
        while (n3 < n) {
            jobTrace.debug(byArray[n3] + " " + byArray[n3 + 1]);
            int n4 = this.rpc.cl.packet.ub(byArray[n3 + 1]) * 256 + this.rpc.cl.packet.ub(byArray[n3]);
            cArray[n3 / 2] = (char)n4;
            if (n4 > 256) {
                bl = true;
                n = byArray.length;
            }
            n3 += 2;
        }
        String string = bl ? new String(cArray) : new String(byArray);
        return string;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        jobTrace.enter(this.o, "getTime", "" + n);
        String string = "error";
        try {
            string = this.getString(n);
            if (string == null) {
                return null;
            }
            if (this.wasNull()) {
                return null;
            }
            if (string.length() == 23) {
                string = string.substring(11);
            }
            Integer n2 = new Integer(string.substring(0, 2));
            Integer n3 = new Integer(string.substring(3, 5));
            Integer n4 = new Integer(string.substring(6, 8));
            return (Time)jobTrace.returnObject(new Time(n2, n3, n4));
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, string + " Cannot be read as Time");
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        jobTrace.enter(this.o, "getTime(" + n + ")");
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        long l = time.getTime();
        calendar.setTime(new Date(l));
        return (Time)jobTrace.returnObject(new Time(calendar.getTime().getTime()));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        jobTrace.enter(this.o, "getTimeStamp", "" + n);
        String string = "error";
        try {
            Integer n2;
            Integer n3;
            Integer n4;
            string = this.getString(n);
            if (string == null || string.equals("")) {
                return null;
            }
            if (this.wasNull()) {
                return null;
            }
            Integer n5 = new Integer(string.substring(0, 4));
            Integer n6 = new Integer(string.substring(5, 7));
            Integer n7 = new Integer(string.substring(8, 10));
            if (string.length() >= 13) {
                n4 = new Integer(string.substring(11, 13));
                n3 = new Integer(string.substring(14, 16));
                n2 = new Integer(string.substring(17, 19));
            } else {
                n4 = new Integer(0);
                n3 = new Integer(0);
                n2 = new Integer(0);
            }
            return (Timestamp)jobTrace.returnObject(new Timestamp(n5 - 1900, n6 - 1, n7, n4, n3, n2, 0));
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, string + " cannot be read as TimeStamp, getTimeStamp(" + n + ") failed");
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        jobTrace.enter(this.o, "getTimeStamp(" + n + ")");
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return null;
        }
        long l = ((java.util.Date)timestamp).getTime();
        calendar.setTime(new Date(l));
        return (Timestamp)jobTrace.returnObject(new Timestamp(calendar.getTime().getTime()));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public int getType() throws SQLException {
        jobTrace.enter(this.o, "getType()");
        return jobTrace.returnInt(this.stmt.resultSetType);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        jobTrace.enter(this.o, "getUnicodeStream", "" + n);
        try {
            short s = this.unicodeFlag;
            this.unicodeFlag = (short)2;
            String string = this.getString(n);
            this.unicodeFlag = s;
            return new ByteArrayInputStream(this.swapHighLowBytes(this.data));
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "column + " + n + " cannot be read as a unicode stream" + sQLException.getMessage());
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        jobTrace.enter(this.o, "getUnicodeStream(" + string + ")");
        return (InputStream)jobTrace.returnObject(this.getBinaryStream(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        String string = "";
        string = this.rpc.jdbc_getWarnings(this.o, "getWarnings", this.rpc.cl.jobHandle);
        if (string.equals("")) {
            return (SQLWarning)jobTrace.returnObject(null);
        }
        return (SQLWarning)jobTrace.returnObject(new SQLWarning("RESULTSET: " + string));
    }

    public void insertRow() throws SQLException {
        jobTrace.enter(this.o, "insertRow");
        if (this.bps == null) {
            this.bps = new BPS(this);
        }
        this.bps.insertRow();
        this.rowStatus = this.rpc.sql_SetPos(this.o, "insertRow", this.hStmt, 0L, (short)4);
    }

    public boolean isAfterLast() throws SQLException {
        jobTrace.enter(this.o, "isAfterLast");
        if (!this.previous()) {
            return jobTrace.returnBool(false);
        }
        this.currentRow = this.getRow();
        if (this.currentRow == 0) {
            return jobTrace.returnBool(false);
        }
        this.last();
        if (this.currentRow == this.getRow()) {
            this.next();
            return jobTrace.returnBool(true);
        }
        this.absolute(this.currentRow);
        this.next();
        return jobTrace.returnBool(false);
    }

    public boolean isBeforeFirst() throws SQLException {
        jobTrace.enter(this.o, "isBeforeFirst");
        if (!this.next()) {
            return jobTrace.returnBool(false);
        }
        this.currentRow = this.getRow();
        if (this.currentRow == 0) {
            this.previous();
            return jobTrace.returnBool(false);
        }
        this.first();
        if (this.currentRow == this.getRow()) {
            this.previous();
            return jobTrace.returnBool(true);
        }
        this.absolute(this.currentRow);
        this.previous();
        return jobTrace.returnBool(false);
    }

    public boolean isFirst() throws SQLException {
        jobTrace.enter(this.o, "isFirst");
        try {
            if (this.getRow() == 1) {
                return jobTrace.returnBool(true);
            }
            return jobTrace.returnBool(false);
        }
        catch (SQLException sQLException) {
            String string = this.rpc.jdbc_getStatusCode("", "", this.rpc.cl.jobHandle);
            if (string.equals("24000")) {
                return jobTrace.returnBool(false);
            }
            throw sQLException;
        }
    }

    public boolean isLast() throws SQLException {
        jobTrace.enter(this.o, "isLast");
        try {
            this.currentRow = this.getRow();
            if (this.currentRow == 0) {
                return jobTrace.returnBool(false);
            }
            this.last();
            if (this.currentRow == this.getRow()) {
                return jobTrace.returnBool(true);
            }
            this.absolute(this.currentRow);
            return jobTrace.returnBool(false);
        }
        catch (SQLException sQLException) {
            String string = this.rpc.jdbc_getStatusCode("", "", this.rpc.cl.jobHandle);
            if (string.equals("24000")) {
                return jobTrace.returnBool(false);
            }
            throw sQLException;
        }
    }

    public boolean last() throws SQLException {
        if (this.stmt.resultSetType == 1003) {
            throw new SQLException("last() called on FORWARD_ONLY result set", "HY000");
        }
        this.reset_row();
        long l = this.rpc.sql_MoveLast(this.o, "last", this.hStmt);
        if (l < 0L) {
            this.currentRow = -1;
            return this.returnExtendedFetch((int)(l += 1000L), "last()");
        }
        this.currentRow = (int)((long)this.currentRow + l);
        return true;
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.insertRow > 0) {
            this.absolute(this.insertRow);
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.last();
        this.insertRow = this.currentRow > 0 ? this.getRow() + 1 : 0;
    }

    private void reset_row() {
        this.reset_row(this.numCols);
    }

    private void reset_row(int n) {
        int n2;
        if (this.columnStringArray != null && this.columnStringArray.length != n + 1) {
            n2 = 0;
            while (n2 < this.columnStringArray.length) {
                this.columnStringArray[n2] = null;
                ++n2;
            }
            this.columnStringArray = null;
        }
        if (this.columnStringArray == null) {
            this.columnStringArray = new String[n + 1];
        }
        n2 = 0;
        while (n2 < n + 1) {
            this.columnStringArray[n2] = null;
            ++n2;
        }
    }

    public boolean next() throws SQLException {
        this.reset_row();
        boolean bl = this.nextInternal();
        if (bl) {
            ++this.currentRow;
        }
        return jobTrace.returnBool(bl);
    }

    public boolean nextInternal() throws SQLException {
        jobTrace.enter(this.o, "next");
        if (this.numCols == 0) {
            return false;
        }
        if (this.stmt.fetchSize == 0) {
            if (this.stmt.resultSetType != 1003) {
                short s = this.rpc.sql_ExtendedFetch(this.o, "next", this.hStmt, (short)1, 0L);
                return jobTrace.returnBool(this.returnExtendedFetch(s, "next()"));
            }
            if (this.rpc.jdbc_nextX(this.o, "next", this.hStmt) == 0) {
                return jobTrace.returnBool("next", true);
            }
            return jobTrace.returnBool("next", false);
        }
        if (this.fetchSize == -1) {
            return this.sbfm.next();
        }
        throw new SQLException("JOB client Error 101");
    }

    public boolean previous() throws SQLException {
        if (this.stmt.resultSetType == 1003) {
            throw new SQLException("previous() called on FORWARD_ONLY result set", "HY000");
        }
        this.reset_row();
        boolean bl = this.returnExtendedFetch(this.rpc.sql_ExtendedFetch(this.o, "previous", this.hStmt, (short)4, 0L), "previous");
        if (bl || this.currentRow == 1) {
            --this.currentRow;
        }
        return bl;
    }

    public void refreshRow() throws SQLException {
        this.reset_row();
        this.rpc.sql_SetPos(this.o, "refreshRow", this.hStmt, 0L, (short)1);
    }

    public boolean relative(int n) throws SQLException {
        if (this.stmt.resultSetType == 1003) {
            throw new SQLException("relative( int row ) called on FORWARD_ONLY result set", "HY000");
        }
        if (this.currentRow == 0) {
            throw new SQLException("There is no current row");
        }
        this.reset_row();
        boolean bl = this.returnExtendedFetch(this.rpc.sql_ExtendedFetch(this.o, "relative", this.hStmt, (short)6, n), "relative");
        if (bl) {
            this.currentRow += n;
        }
        return bl;
    }

    public void renameColumn(String string, String string2) {
        jobColumn jobColumn2 = (jobColumn)this.columnNames.get(string2);
        if (jobColumn2 != null) {
            jobColumn2.setName(string);
            this.columnNames.put(string2, jobColumn2);
            if (this.columnNames.containsKey(string)) {
                jobTrace.println("Column : " + string + "is already in the result set");
            } else {
                this.columnNames.put(string, jobColumn2);
            }
            this.columnInfoArray[jobColumn2.getIndex()] = jobColumn2;
        }
    }

    public boolean rowDeleted() throws SQLException {
        return this.rowStatus == 1;
    }

    public boolean rowInserted() throws SQLException {
        return this.rowStatus == 4;
    }

    public boolean rowUpdated() throws SQLException {
        return this.rowStatus == 2;
    }

    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = n;
                return;
            }
        }
        throw new SQLException("Invalid value for FetchDirection:" + n);
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Attempt to set FetchSize value to invalid value: " + n);
        }
        this.fetchSize = n;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            jobTrace.enter(this.o, "updateAsciiStream(" + n + ", " + inputStream + ", " + n2 + ")");
            inputStream.read(byArray, 0, n2);
            String string = new String(byArray);
            jobTrace.debug("data as string" + string + "|End of In STring!");
            jobTrace.debug("length: " + string.length());
            this.updateString(n, string);
            jobTrace.returnVoid("updateAsciiStream");
        }
        catch (IOException iOException) {
            throw new SQLException(jobDriver.errorPrefix + "updateAsciiStream failed: " + iOException.getMessage(), "HY000");
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateString(n, bigDecimal.toString());
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        boolean bl = false;
        boolean bl2 = false;
        try {
            jobTrace.enter(this.o, "updateBinaryStream(" + n + ", " + inputStream + ")");
            inputStream.read(byArray, 0, n2);
            this.updateBytes(n, byArray);
            jobTrace.returnVoid();
        }
        catch (IOException iOException) {
            throw new SQLException(jobDriver.errorPrefix + "updateBinaryStream(" + n + ") failed: " + iOException.getMessage());
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        String string = "1";
        if (bl) {
            string = "0";
        }
        this.updateString(n, string);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateString(n, new Byte(by).toString());
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        jobTrace.enter(this.o, "updateBytes(" + n + ", " + byArray + ")");
        if (this.bps == null) {
            this.bps = new BPS(this);
        }
        this.bps.setParam(n, -2, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            jobTrace.enter(this.o, "updateCharacterStream(" + n + ", " + n2 + ")");
            if (this.rpc.cl.unicodeFlag == 0) {
                int n3;
                byte[] byArray = new byte[n2 + 1];
                int n4 = 0;
                while ((n3 = reader.read()) > -1) {
                    byte by = (byte)(n3 % 256);
                    byArray[n4++] = this.tub(by);
                }
                byArray[n4] = 0;
                this.updateBytes(n, byArray);
            } else {
                int n5;
                byte[] byArray = new byte[2 * n2];
                int n6 = 0;
                while ((n5 = reader.read()) > -1) {
                    byte by = (byte)(n5 / 256);
                    byte by2 = (byte)(n5 % 256);
                    byArray[n6++] = this.tub(by2);
                    byArray[n6++] = this.tub(by);
                }
                this.updateBytes(n, byArray);
            }
            jobTrace.returnVoid("updateCharacterStream");
        }
        catch (IOException iOException) {
            throw new SQLException(jobDriver.errorPrefix + "updateCharacterStream(" + n + ") failed: " + iOException.getMessage());
        }
    }

    byte tub(byte by) {
        return by < 0 ? (byte)(128 + by) : by;
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateString(n, date.toString());
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateString(n, new Double(d).toString());
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateString(n, new Float(f).toString());
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateString(n, new Integer(n2).toString());
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateString(n, new Long(l).toString());
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        jobTrace.enter(this.o, "updateNull", "index=" + n);
        byte[] byArray = new byte[4];
        int n2 = this.getMetaData().getColumnType(n);
        if (this.bps == null) {
            this.bps = new BPS(this);
        }
        this.bps.setParam(n, 0, this.rpc.cl.packet.write4Bytes(n2, 0, byArray));
        jobTrace.returnVoid("updateNull");
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateString(n, object.toString());
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        jobTrace.enter(this.o, "updateRow");
        this.rowUpdated = false;
        if (this.bps == null) {
            this.bps = new BPS(this);
        }
        this.bps.updateRow();
        this.rowStatus = this.rpc.sql_SetPos(this.o, "updateRow", this.hStmt, 0L, (short)2);
        this.rowUpdated = true;
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateString(n, new Short(s).toString());
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        jobTrace.enter(this.o, "updateString", "index=" + n + ", " + "x=" + string);
        if (this.bps == null) {
            this.bps = new BPS(this);
        }
        this.bps.setParam(n, 1, string.getBytes());
        jobTrace.returnVoid("updateString");
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateString(n, time.toString());
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.bps == null) {
            this.bps = new BPS(this);
        }
        this.updateString(n, timestamp.toString());
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        jobTrace.enter(this.o, "wasNull");
        jobTrace.debug("Fetch size tested in wasNull: " + this.fetchSize);
        if (this.fetchSize == -1) {
            return jobTrace.returnBool("wasNull", this.sbfm.wasNull());
        }
        try {
            if (this.rpc.jdbc_wasNull(this.o, "wasNull", this.hStmt) == 0) {
                return jobTrace.returnBool("wasNull", true);
            }
            return jobTrace.returnBool("wasNull", false);
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "ResultSet.wasNull() failed");
        }
    }

    void checkHandle() throws SQLException {
        if (this.hStmt == 0L) {
            throw new SQLException("Statement is closed");
        }
    }

    private boolean returnExtendedFetch(int n, String string) throws SQLException {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 100: {
                return false;
            }
            case 2: {
                throw new SQLException("Statement is still executing while calling " + string);
            }
            case -1: {
                throw new SQLException("Error in executing " + string);
            }
            case -2: {
                throw new SQLException("Invalid handle while calling " + string);
            }
        }
        throw new SQLException("Unknown return value for  " + string);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public char[] makeCharArray(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        jobTrace.debug("Calling makeCharacterArray" + new String(byArray));
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            cArray[n] = by < 0 ? (char)(256 + by) : (char)by;
            ++n;
        }
        jobTrace.debug("Returning makeCharacterArray" + new String(cArray));
        return cArray;
    }
}

