/*
 * $Source: /usr/cvsroot/melati/melati/src/main/java/org/melati/admin/AdminSpecialised.java,v $
 * $Revision: 1.12 $
 *
 * Copyright (C) 2000 William Chesters
 *
 * Part of Melati (http://melati.org), a framework for the rapid
 * development of clean, maintainable web applications.
 *
 * Melati is free software; Permission is granted to copy, distribute
 * and/or modify this software under the terms either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version,
 *
 *    or
 *
 * b) any version of the Melati Software License, as published
 *    at http://melati.org
 *
 * You should have received a copy of the GNU General Public License and
 * the Melati Software License along with this program;
 * if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA to obtain the
 * GNU General Public License and visit http://melati.org to obtain the
 * Melati Software License.
 *
 * Feel free to contact the Developers of Melati (http://melati.org),
 * if you would like to work out a different arrangement than the options
 * outlined here.  It is our intention to allow Melati to be used by as
 * wide an audience as possible.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Contact details for copyright holder:
 *
 *     William Chesters <williamc@paneris.org>
 *     http://paneris.org/~williamc
 *     Obrechtstraat 114, 2517VX Den Haag, The Netherlands
 */

package org.melati.admin;

import org.melati.Melati;
import org.melati.template.MarkupLanguage;

/**
 * An interface that allows the editting and display of an object 
 * to be extended.
 * To process the object in a special way your template should use 
 * a method other than <code>Update</code>.
 */

public interface AdminSpecialised {

  /**
   * Perform the specialised function and return the name of the
   * template presenting the results.
   * Return null if not used.
   * 
   * @see org.melati.admin.Admin
   * @param melati         the current {@link Melati}
   * @param markupLanguage the current {@link MarkupLanguage}
   * @return the name of a special template or null if not used
   * @throws Exception if anything goes wrong
   */
  String adminHandle (Melati melati, MarkupLanguage markupLanguage)
      throws Exception;
  
  /**
   * Returns the name of a templet which provides access to the
   * specialised functionality.
   * The results of the template are currently included at the bottom of the 
   * standard edit page.
   * 
   * see also org.melati.admin.Edit.wm
   * @see org.melati.admin.AdminUtils
   * @param melati         the current {@link Melati}
   * @param markupLanguage the current {@link MarkupLanguage}
   * @return the name of a special templet or null if not used
   * @throws Exception if anything goes wrong
   */
  String adminSpecialFacilities (Melati melati, MarkupLanguage markupLanguage)
      throws Exception;
}
