/*
 * $Source: /usr/cvsroot/melati/melati/src/main/java/org/melati/template/MissingFieldException.java,v $
 * $Revision: 1.6 $
 *
 * Copyright (C) 2000 William Chesters
 *
 * Part of Melati (http://melati.org), a framework for the rapid
 * development of clean, maintainable web applications.
 *
 * Melati is free software; Permission is granted to copy, distribute
 * and/or modify this software under the terms either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version,
 *
 *    or
 *
 * b) any version of the Melati Software License, as published
 *    at http://melati.org
 *
 * You should have received a copy of the GNU General Public License and
 * the Melati Software License along with this program;
 * if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA to obtain the
 * GNU General Public License and visit http://melati.org to obtain the
 * Melati Software License.
 *
 * Feel free to contact the Developers of Melati (http://melati.org),
 * if you would like to work out a different arrangement than the options
 * outlined here.  It is our intention to allow Melati to be used by as
 * wide an audience as possible.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Contact details for copyright holder:
 *
 *     William Chesters <williamc At paneris.org>
 *     http://paneris.org/~williamc
 *     Obrechtstraat 114, 2517VX Den Haag, The Netherlands
 */

package org.melati.template;

import org.melati.util.MelatiRuntimeException;

/**
 * Thrown when a {@link TempletAdaptor} cannot find a required form field 
 * in a templet.
 */
public class MissingFieldException extends MelatiRuntimeException {


  private static final long serialVersionUID = -4695114906098564625L;

  TempletAdaptor adaptor;
  String name;
  String fullName;
  
  /**
   * Constructor.
   * @param adaptor the TempletAdaptor
   * @param name name of compound field
   * @param fullName name of sub-field
   */
  public MissingFieldException(TempletAdaptor adaptor,
                               String name, String fullName) {
    this.adaptor = adaptor;
    this.name = name;
    this.fullName = fullName;
  }

  /**
   * {@inheritDoc}
   * @see org.melati.util.MelatiRuntimeException#getMessage()
   */
  public String getMessage() {
    return
        "The templet adaptor `" + adaptor + "' was looking for a form field " +
        "`" + fullName + "' as part of a compound field `" + name + "', " +
        "but it was not present. " +
        "Maybe a bug in the adaptor, or more likely in an associated templet.";
  }
}
