/*
 * $Source: /usr/cvsroot/melati/melati/src/main/java/org/melati/template/webmacro/WebmacroServletTemplateContext.java,v $
 * $Revision: 1.11 $
 *
 * Copyright (C) 2000 Tim Joyce
 *
 * Part of Melati (http://melati.org), a framework for the rapid
 * development of clean, maintainable web applications.
 *
 * Melati is free software; Permission is granted to copy, distribute
 * and/or modify this software under the terms either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version,
 *
 *    or
 *
 * b) any version of the Melati Software License, as published
 *    at http://melati.org
 *
 * You should have received a copy of the GNU General Public License and
 * the Melati Software License along with this program;
 * if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA to obtain the
 * GNU General Public License and visit http://melati.org to obtain the
 * Melati Software License.
 *
 * Feel free to contact the Developers of Melati (http://melati.org),
 * if you would like to work out a different arrangement than the options
 * outlined here.  It is our intention to allow Melati to be used by as
 * wide an audience as possible.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Contact details for copyright holder:
 *
 * Tim Joyce <timj At paneris.org>
 *
 */

package org.melati.template.webmacro;

import javax.servlet.http.HttpSession;

import org.melati.template.ServletTemplateContext;
import org.melati.util.MelatiBugMelatiException;
import org.melati.servlet.MultipartFormField;
import org.webmacro.Context;
import org.webmacro.servlet.WebContext;

/**
 * Implements a template context for Melati using Webmacro.
 * 
 * @author Tim Joyce
 */
public class WebmacroServletTemplateContext 
    extends WebmacroTemplateContext
    implements ServletTemplateContext {

  /** The webcontext. */
  public WebContext webContext;

  /**
   * Constructor.
   * @param wc WebMacro context
   */
  public WebmacroServletTemplateContext(Context wc) {
    super(wc);
    webContext = (WebContext)wc;
  }

  /**
   * Returns null if not present, empty string if empty.
   * {@inheritDoc}
   * @see org.melati.template.ServletTemplateContext#getForm(java.lang.String)
   */
  public String getFormField(String k) {
    return webContext.getForm(k);
  }

  /**
   * Throws an exception as this is not a multi part form.
   * Should perhaps throw an exception.
   * @see org.melati.template.ServletTemplateContext#getMultipartForm(java.lang.String)
   */
  public MultipartFormField getMultipartFormField(String s) {
    throw new MelatiBugMelatiException("Cannot return a multi-part field from a non-multi-part form");
  }

  /**
   * {@inheritDoc}
   * @see org.melati.template.ServletTemplateContext#getSession()
   */
  public HttpSession getSession() {
    return webContext.getSession();
  }
  
}






