/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import org.melati.poem.AccessPoemException;
import org.melati.poem.Column;
import org.melati.poem.ColumnInfo;
import org.melati.poem.DefinitionSource;
import org.melati.poem.Field;
import org.melati.poem.FieldAttributes;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Table;
import org.melati.poem.ValidationPoemException;

public class ExtraColumn
extends Column {
    private final int extrasIndex;

    public ExtraColumn(Table table, String name, SQLPoemType type, DefinitionSource definitionSource, int extrasIndex) {
        super(table, name, type, definitionSource);
        this.extrasIndex = extrasIndex;
    }

    public Object getRaw(Persistent g) throws AccessPoemException {
        ((JdbcPersistent)g).readLock();
        return this.getRaw_unsafe(g);
    }

    public Object getRaw_unsafe(Persistent g) {
        return ((JdbcPersistent)g).extras()[this.extrasIndex];
    }

    public void setRaw(Persistent g, Object raw) throws AccessPoemException, ValidationPoemException {
        this.getType().assertValidRaw(raw);
        ((JdbcPersistent)g).writeLock();
        this.setRaw_unsafe(g, raw);
    }

    public void setRaw_unsafe(Persistent g, Object raw) {
        ((JdbcPersistent)g).extras()[this.extrasIndex] = raw;
    }

    public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
        return this.getType().cookedOfRaw(this.getRaw(g));
    }

    public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
        this.getType().assertValidCooked(cooked);
        this.setRaw(g, this.getType().rawOfCooked(cooked));
    }

    public Field asField(Persistent g) {
        try {
            return new Field(this.getRaw(g), (FieldAttributes)this);
        }
        catch (AccessPoemException accessException) {
            return new Field(accessException, (FieldAttributes)this);
        }
    }

    public static Column from(Table table, ColumnInfo columnInfo, int extrasIndex, DefinitionSource source) {
        return new ExtraColumn(table, columnInfo.getName(), columnInfo.getType(), source, extrasIndex);
    }
}

