/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.io.PrintStream;
import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.BaseFieldAttributes;
import org.melati.poem.FieldAttributes;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.Persistent;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemType;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.util.LimitedEnumeration;
import org.melati.poem.util.MappedEnumeration;

public class Field
implements FieldAttributes,
Cloneable {
    private AccessPoemException accessException;
    private Object raw;
    private FieldAttributes attrs;

    public Field(Object raw, FieldAttributes attrs) {
        this.raw = raw;
        this.attrs = attrs;
        this.accessException = null;
    }

    public Field(AccessPoemException accessException, FieldAttributes attrs) {
        this.accessException = accessException;
        this.attrs = attrs;
        this.raw = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnexpectedExceptionPoemException(e, "Object no longer supports clone.");
        }
    }

    public String getName() {
        return this.attrs.getName();
    }

    public String getDisplayName() {
        return this.attrs.getDisplayName();
    }

    public String getDescription() {
        return this.attrs.getDescription();
    }

    public PoemType getType() {
        return this.attrs.getType();
    }

    public boolean getIndexed() {
        return this.attrs.getIndexed();
    }

    public boolean getUserEditable() {
        return this.attrs.getUserEditable();
    }

    public boolean getUserCreateable() {
        return this.attrs.getUserCreateable();
    }

    public int getWidth() {
        return this.attrs.getWidth();
    }

    public int getHeight() {
        return this.attrs.getHeight();
    }

    public String getRenderInfo() {
        return this.attrs.getRenderInfo();
    }

    public final Object getRaw() throws AccessPoemException {
        if (this.accessException != null) {
            throw this.accessException;
        }
        return this.raw;
    }

    public final Object getRawString() throws AccessPoemException {
        if (this.accessException != null) {
            throw this.accessException;
        }
        return this.raw == null ? "" : this.getType().stringOfRaw(this.raw);
    }

    public final Object getCooked() throws AccessPoemException {
        if (this.accessException != null) {
            throw this.accessException;
        }
        return this.getType().cookedOfRaw(this.raw);
    }

    public final String getCookedString() throws AccessPoemException {
        return this.getCookedString(PoemLocale.HERE, 3);
    }

    public final String getCookedString(PoemLocale locale, int style) throws AccessPoemException {
        if (this.accessException != null) {
            throw this.accessException;
        }
        return this.raw == null ? "" : this.getType().stringOfCooked(this.getCooked(), locale, style);
    }

    public Field withRaw(Object rawP) {
        Field it = (Field)this.clone();
        it.raw = rawP;
        return it;
    }

    public Field withNullable(boolean nullable) {
        return new Field(this.raw, (FieldAttributes)new BaseFieldAttributes(this.attrs, nullable));
    }

    public Field withName(String name) {
        return new Field(this.raw, (FieldAttributes)new BaseFieldAttributes(this.attrs, name));
    }

    public Field withDescription(String description) {
        return new Field(this.raw, (FieldAttributes)new BaseFieldAttributes(this.attrs, this.attrs.getName(), description));
    }

    public Enumeration getPossibilities() {
        final Field _this = this;
        Enumeration en = this.getType().possibleRaws();
        return en == null ? null : new MappedEnumeration(en){

            protected Object mapped(Object rawP) {
                return _this.withRaw(rawP);
            }
        };
    }

    public Enumeration getFirst1000Possibilities() {
        Enumeration en = this.getPossibilities();
        return en == null ? null : new LimitedEnumeration(en, 1000);
    }

    public boolean sameRawAs(Field other) throws AccessPoemException {
        if (this.accessException != null) {
            throw this.accessException;
        }
        return this.raw == null ? other.raw == null : this.raw.equals(other.raw);
    }

    public void dump(PrintStream p) {
        p.print(this.toString());
    }

    public String toString() {
        return this.getName() + ": " + this.getCookedString(PoemLocale.HERE, 2);
    }

    public static Field basic(Object value, String name, PoemType type) {
        return new Field(value, (FieldAttributes)new BaseFieldAttributes(name, name, null, type, 20, 1, null, false, true, true));
    }

    public static Field string(String value, String name) {
        return Field.basic(value, name, StringPoemType.nullableInstance);
    }

    public static Field integer(Integer value, String name) {
        return Field.basic(value, name, IntegerPoemType.nullableInstance);
    }

    public static Field reference(Persistent value, String name) {
        return Field.basic(value.troid(), name, new ReferencePoemType(value.getTable(), true));
    }

    public static Field reference(Table table, String name) {
        return Field.basic(null, name, new ReferencePoemType(table, true));
    }
}

