/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.RowDisappearedPoemException;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.util.SkipEnumeration;

public abstract class ResultSetEnumeration
implements SkipEnumeration {
    private final ResultSet resultSet;
    private int more = -1;

    public ResultSetEnumeration(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    private int resultSetNext() throws SQLException {
        if (this.resultSet.next()) {
            return 1;
        }
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
        return 0;
    }

    public synchronized boolean hasMoreElements() {
        try {
            if (this.more == -1) {
                this.more = this.resultSetNext();
            }
            return this.more == 1;
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    protected abstract Object mapped(ResultSet var1) throws SQLException, NoSuchRowPoemException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object nextElement() throws NoSuchElementException {
        Object object;
        if (this.more == -1) {
            this.more = this.resultSetNext();
        }
        if (this.more == 0) {
            throw new NoSuchElementException();
        }
        try {
            object = this.mapped(this.resultSet);
        }
        catch (Throwable throwable) {
            try {
                this.more = this.resultSetNext();
                throw throwable;
            }
            catch (SQLException e) {
                throw new SQLSeriousPoemException(e);
            }
            catch (NoSuchRowPoemException e) {
                throw new RowDisappearedPoemException(e);
            }
        }
        this.more = this.resultSetNext();
        return object;
    }

    public synchronized void skip() throws NoSuchElementException {
        try {
            if (this.more == -1) {
                this.more = this.resultSetNext();
            }
            if (this.more == 0) {
                throw new NoSuchElementException();
            }
            this.more = this.resultSetNext();
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }
}

