/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.melati.poem.PoemException;
import org.melati.poem.util.CacheDuplicationException;
import org.melati.poem.util.ConsEnumeration;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.FilteredEnumeration;
import org.melati.poem.util.MappedEnumeration;
import org.melati.poem.util.Procedure;

public final class Cache {
    private Hashtable table = new Hashtable();
    private HeldNode theMRU = null;
    private HeldNode theLRU = null;
    private int heldNodes = 0;
    private int maxSize;
    private int collectedEver = 0;
    private ReferenceQueue collectedValuesQueue = new ReferenceQueue();

    private Vector invariantBreaches() {
        Vector<String> probs = new Vector<String>();
        if (this.theMRU != null && this.theMRU.prevMRU != null) {
            probs.addElement("theMRU.prevMRU == " + this.theMRU.prevMRU);
        }
        if (this.theLRU != null && this.theLRU.nextMRU != null) {
            probs.addElement("theLRU.nextMRU == " + this.theLRU.nextMRU);
        }
        Object[] held = new Object[this.heldNodes];
        Hashtable<HeldNode, Boolean> heldHash = new Hashtable<HeldNode, Boolean>();
        int countML = 0;
        HeldNode n = this.theMRU;
        while (n != null) {
            if (this.table.get(n.key()) != n) {
                probs.addElement("MRU list check: table.get(" + n + ".key()) == " + this.table.get(n.key()));
            }
            if (countML < this.heldNodes) {
                held[countML] = n;
            }
            heldHash.put(n, Boolean.TRUE);
            n = n.nextMRU;
            ++countML;
        }
        if (countML != this.heldNodes) {
            probs.addElement(countML + " nodes in MRU->LRU not " + this.heldNodes);
        }
        Hashtable<Object, HeldNode> keys = new Hashtable<Object, HeldNode>();
        int countLM = 0;
        HeldNode n2 = this.theLRU;
        while (n2 != null) {
            int o;
            HeldNode oldn = (HeldNode)keys.get(n2.key());
            if (oldn != null) {
                probs.addElement("key " + n2.key() + " duplicated in " + n2 + " and " + oldn);
            }
            keys.put(n2.key(), n2);
            if (this.table.get(n2.key()) != n2) {
                probs.addElement("LRU list check: table.get(" + n2 + ".key()) == " + this.table.get(n2.key()));
            }
            if (countLM < this.heldNodes && n2 != held[o = this.heldNodes - (1 + countLM)]) {
                probs.addElement("lm[" + countLM + "] == " + n2 + " != ml[" + o + "] == " + held[o]);
            }
            n2 = n2.prevMRU;
            ++countLM;
        }
        Enumeration nodes = this.table.elements();
        while (nodes.hasMoreElements()) {
            Node n3 = (Node)nodes.nextElement();
            if (!(n3 instanceof HeldNode) || heldHash.containsKey(n3)) continue;
            probs.addElement(n3 + " in table but not MRU->LRU");
        }
        if (countLM != this.heldNodes) {
            probs.addElement(countLM + " nodes in LRU->MRU not " + this.heldNodes);
        }
        return probs;
    }

    private void assertInvariant() {
        Vector probs;
        boolean debug = false;
        if (debug && (probs = this.invariantBreaches()).size() != 0) {
            throw new InconsistencyException(probs);
        }
    }

    public Cache(int maxSize) {
        this.setSize(maxSize);
    }

    public void setSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException();
        }
        this.maxSize = maxSize;
    }

    public int getSize() {
        return this.maxSize;
    }

    private synchronized void checkForGarbageCollection() {
        DroppedNode collected;
        while ((collected = (DroppedNode)this.collectedValuesQueue.poll()) != null) {
            this.table.remove(collected.key());
            ++this.collectedEver;
        }
    }

    public synchronized void trim(int maxSize_P) {
        this.checkForGarbageCollection();
        HeldNode n = this.theLRU;
        while (n != null && this.heldNodes > maxSize_P) {
            HeldNode nn = n.prevMRU;
            n.putBefore(null);
            this.table.put(n.key, new DroppedNode(n.key, n.value, this.collectedValuesQueue));
            --this.heldNodes;
            n = nn;
        }
        if (n == null) {
            this.theLRU = null;
            this.theMRU = null;
        } else {
            this.theLRU = n;
        }
        this.assertInvariant();
    }

    public synchronized void delete(Object key) {
        Node n = (Node)this.table.get(key);
        if (n == null) {
            return;
        }
        if (n instanceof HeldNode) {
            HeldNode h = (HeldNode)n;
            if (this.theLRU == h) {
                this.theLRU = h.prevMRU;
            }
            if (this.theMRU == h) {
                this.theMRU = h.nextMRU;
            }
            h.putBefore(null);
            --this.heldNodes;
        }
        this.table.remove(key);
        this.assertInvariant();
    }

    public synchronized void put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.trim(this.maxSize);
        if (this.maxSize == 0) {
            this.table.put(key, new DroppedNode(key, value, this.collectedValuesQueue));
        } else {
            HeldNode node = new HeldNode(key, value);
            HeldNode previous = this.table.put(key, node);
            if (previous != null) {
                this.table.put(key, previous);
                throw new CacheDuplicationException("Key already in cache for key=" + key + ", value=" + value);
            }
            node.putBefore(this.theMRU);
            this.theMRU = node;
            if (this.theLRU == null) {
                this.theLRU = node;
            }
            ++this.heldNodes;
            this.assertInvariant();
        }
    }

    public synchronized Object get(Object key) {
        HeldNode held;
        this.checkForGarbageCollection();
        Node node = (Node)this.table.get(key);
        if (node == null) {
            return null;
        }
        if (node instanceof HeldNode) {
            held = (HeldNode)node;
            if (held != this.theMRU) {
                if (held == this.theLRU) {
                    this.theLRU = held.prevMRU;
                }
                held.putBefore(this.theMRU);
                this.theMRU = held;
            }
        } else {
            if (node.value() == null) {
                return null;
            }
            held = new HeldNode(key, node.value());
            this.table.put(key, held);
            ++this.heldNodes;
            held.putBefore(this.theMRU);
            this.theMRU = held;
            if (this.theLRU == null) {
                this.theLRU = held;
            }
            this.trim(this.maxSize);
        }
        this.assertInvariant();
        return held.value;
    }

    public synchronized void iterate(Procedure f) {
        this.checkForGarbageCollection();
        Enumeration n = this.table.elements();
        while (n.hasMoreElements()) {
            Object value = ((Node)n.nextElement()).value();
            if (value == null) continue;
            f.apply(value);
        }
    }

    public Enumeration getReport() {
        return new ConsEnumeration("" + this.maxSize + " maxSize, " + this.theMRU + " theMRU, " + this.theLRU + " theLRU, " + this.collectedEver + " collectedEver", new ConsEnumeration(this.heldNodes + " held, " + this.table.size() + " total ", this.invariantBreaches().elements()));
    }

    public Info getInfo() {
        return new Info();
    }

    public void dumpAnalysis() {
        Enumeration l = this.getReport();
        while (l.hasMoreElements()) {
            System.err.println(l.nextElement());
        }
    }

    public void dump() {
        System.err.println("Keys: " + this.table.size());
        System.err.println("maxSize: " + this.maxSize);
        System.err.println("theMRU: " + this.theMRU);
        System.err.println("theLRU: " + this.theLRU);
        System.err.println("heldNodes: " + this.heldNodes);
        System.err.println("collectedEver: " + this.collectedEver);
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            System.err.print(k);
            System.err.print(" : ");
            System.err.println(this.table.get(k));
        }
    }

    public final class Info {
        private Info() {
        }

        public Enumeration getHeldElements() {
            Cache.this.checkForGarbageCollection();
            return new MappedEnumeration(new FilteredEnumeration(Cache.this.table.elements()){

                public boolean isIncluded(Object o) {
                    return o instanceof HeldNode;
                }
            }){

                public Object mapped(Object o) {
                    return ((Node)o).value();
                }
            };
        }

        public Enumeration getDroppedElements() {
            Cache.this.checkForGarbageCollection();
            return new MappedEnumeration(new FilteredEnumeration(Cache.this.table.elements()){

                public boolean isIncluded(Object o) {
                    return o instanceof DroppedNode;
                }
            }){

                public Object mapped(Object o) {
                    return ((Node)o).value();
                }
            };
        }

        public Enumeration getReport() {
            return Cache.this.getReport();
        }
    }

    public class InconsistencyException
    extends PoemException {
        private static final long serialVersionUID = 1832694552964508864L;
        public Vector probs;

        public InconsistencyException(Vector probs) {
            this.probs = probs;
        }

        public String getMessage() {
            return EnumUtils.concatenated("\n", this.probs.elements());
        }
    }

    private static class DroppedNode
    extends SoftReference
    implements Node {
        Object key;

        DroppedNode(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }

        public Object key() {
            return this.key;
        }

        public Object value() {
            return this.get();
        }
    }

    private static class HeldNode
    implements Node {
        Object key;
        Object value;
        HeldNode nextMRU = null;
        HeldNode prevMRU = null;

        HeldNode(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        synchronized void putBefore(HeldNode nextMRU_P) {
            if (this.nextMRU != null) {
                this.nextMRU.prevMRU = this.prevMRU;
            }
            if (this.prevMRU != null) {
                this.prevMRU.nextMRU = this.nextMRU;
            }
            if (nextMRU_P != null) {
                if (nextMRU_P.prevMRU != null) {
                    nextMRU_P.prevMRU.nextMRU = this;
                }
                this.prevMRU = nextMRU_P.prevMRU;
                nextMRU_P.prevMRU = this;
            } else {
                this.prevMRU = null;
            }
            this.nextMRU = nextMRU_P;
        }

        public Object key() {
            return this.key;
        }

        public Object value() {
            return this.value;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            if (this.prevMRU == null) {
                ret.append("null");
            } else {
                ret.append(this.prevMRU.key());
            }
            ret.append(">>" + this.key + "=" + this.value + ">>");
            if (this.nextMRU == null) {
                ret.append("null");
            } else {
                ret.append(this.nextMRU.key());
            }
            return ret.toString();
        }
    }

    private static interface Node {
        public Object key();

        public Object value();
    }
}

