/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import org.melati.poem.Database;
import org.melati.poem.PoemDatabaseFactory;
import org.melati.poem.Table;
import org.melati.poem.TableFactory;
import org.melati.poem.test.PoemTestCase;
import org.melati.poem.test.pojo.ClassWithNoIdAndPublicMembers;
import org.melati.poem.test.pojo.ClassWithStringId;

public class TableFactoryTest
extends PoemTestCase {
    public TableFactoryTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void databaseUnchanged() {
        TableFactoryTest.assertEquals("Setting changed", 0, this.getDb().getSettingTable().count());
        TableFactoryTest.assertEquals("Group changed", 1, this.getDb().getGroupTable().count());
        TableFactoryTest.assertEquals("GroupMembership changed", 1, this.getDb().getGroupMembershipTable().count());
        TableFactoryTest.assertEquals("Capability changed", 5, this.getDb().getCapabilityTable().count());
        TableFactoryTest.assertEquals("GroupCapability changed", 1, this.getDb().getGroupCapabilityTable().count());
        TableFactoryTest.assertEquals("TableCategory changed", 3, this.getDb().getTableCategoryTable().count());
        TableFactoryTest.assertEquals("User changed", 2, this.getDb().getUserTable().count());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.getDb().disconnect();
        PoemDatabaseFactory.removeDatabase((String)this.getDatabaseName());
    }

    public void testFromKnownInstance() {
        TableFactoryTest.assertEquals((Object)this.getDb().getUserTable(), (Object)TableFactory.fromInstance((Database)this.getDb(), (Object)this.getDb().getUserTable().administratorUser()));
    }

    public void testFromUnKnownInstance() {
        Table t = TableFactory.fromInstance((Database)this.getDb(), (Object)new ClassWithNoIdAndPublicMembers());
        TableFactoryTest.assertEquals((String)"ClassWithNoIdAndPublicMembers", (String)t.getName());
    }

    public void testFromObjectWithStringIdField() {
        Table table = TableFactory.fromInstance((Database)this.getDb(), (Object)new ClassWithStringId());
        TableFactoryTest.assertEquals((String)"ClassWithStringId", (String)table.getName());
    }

    public void testFromNonPublicObject() {
        try {
            TableFactory.fromInstance((Database)this.getDb(), (Object)new NonPublicClass());
            TableFactoryTest.fail((String)"Should have blown up.");
        }
        catch (IllegalArgumentException e) {
            Object var1_2 = null;
        }
    }

    public void testFromClassBadInput() {
        try {
            TableFactory.fromClass((Database)this.getDb(), Integer.TYPE);
            TableFactoryTest.fail((String)"Should have blown up");
        }
        catch (IllegalArgumentException e2) {
            Object e2 = null;
        }
        try {
            TableFactory.fromInstance((Database)this.getDb(), (Object)new String[0]);
            TableFactoryTest.fail((String)"Should have blown up");
        }
        catch (IllegalArgumentException e) {
            Object var1_4 = null;
        }
    }

    class NonPublicClass {
        NonPublicClass() {
        }
    }
}

