/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import org.melati.poem.Capability;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.Group;
import org.melati.poem.GroupCapability;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.generated.GroupCapabilityTableBase;

public class GroupCapabilityTable
extends GroupCapabilityTableBase {
    public GroupCapabilityTable(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    @Override
    public void postInitialise() {
        super.postInitialise();
        Database d = this.getDatabase();
        GroupCapability admin = (GroupCapability)this.newPersistent();
        admin.setGroup(d.getGroupTable().administratorsGroup());
        admin.setCapability(d.administerCapability());
        if (!this.exists(admin)) {
            this.create(admin);
        }
    }

    public GroupCapability ensure(Group group, Capability capability) {
        GroupCapability p = (GroupCapability)this.newPersistent();
        p.setGroup(group);
        p.setCapability(capability);
        Enumeration<Persistent> them = this.selection(p);
        if (them.hasMoreElements()) {
            return (GroupCapability)them.nextElement();
        }
        p.makePersistent();
        return p;
    }
}

