/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.AlreadyInSessionPoemException;
import org.melati.poem.Capability;
import org.melati.poem.Database;
import org.melati.poem.NoAccessTokenPoemException;
import org.melati.poem.NonRootSetAccessTokenPoemException;
import org.melati.poem.NotInSessionPoemException;
import org.melati.poem.PoemException;
import org.melati.poem.PoemTask;
import org.melati.poem.PoemTransaction;
import org.melati.poem.SessionToken;
import org.melati.poem.TooManyThreadsPoemException;
import org.melati.poem.transaction.ToTidyList;

public final class PoemThread {
    private static Vector<SessionToken> sessionTokens = new Vector();
    private static Vector<Integer> freeSessionTokenIndices = new Vector();
    public static final int threadsMax = 100;
    private static Map<Integer, String> threadOldNames = new HashMap<Integer, String>();

    private PoemThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer allocatedSessionToken(AccessToken accessToken, PoemTransaction transaction, PoemTask task) {
        Vector<Integer> vector = freeSessionTokenIndices;
        synchronized (vector) {
            Integer index;
            if (freeSessionTokenIndices.size() == 0) {
                int i = sessionTokens.size();
                if (i >= 100) {
                    throw new TooManyThreadsPoemException();
                }
                sessionTokens.setSize(i + 1);
                index = new Integer(i);
            } else {
                index = freeSessionTokenIndices.lastElement();
                freeSessionTokenIndices.setSize(freeSessionTokenIndices.size() - 1);
            }
            SessionToken token = new SessionToken(Thread.currentThread(), transaction, accessToken, task);
            sessionTokens.setElementAt(token, index);
            return index;
        }
    }

    static void beginSession(AccessToken accessToken, PoemTransaction transaction, PoemTask task) throws PoemException {
        if (PoemThread.inSession()) {
            throw new AlreadyInSessionPoemException();
        }
        Integer token = PoemThread.allocatedSessionToken(accessToken, transaction, task);
        String oldname = Thread.currentThread().getName();
        Thread.currentThread().setName("" + (char)token.intValue());
        threadOldNames.put(token, oldname);
    }

    static void beginSession(AccessToken accessToken, PoemTransaction transaction) throws PoemException {
        PoemThread.beginSession(accessToken, transaction, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endSession() throws PoemException {
        char tokenChar = Thread.currentThread().getName().charAt(0);
        Integer token = new Integer(tokenChar);
        String oldname = threadOldNames.get(token);
        if (oldname == null) {
            throw new NotInSessionPoemException(Thread.currentThread().getName() + " has null old name");
        }
        Thread.currentThread().setName(oldname);
        Vector<Integer> vector = freeSessionTokenIndices;
        synchronized (vector) {
            sessionTokens.elementAt(token).close();
            sessionTokens.setElementAt(null, token);
            freeSessionTokenIndices.addElement(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void inSession(PoemTask task, AccessToken accessToken, PoemTransaction transaction) throws PoemException {
        PoemThread.beginSession(accessToken, transaction, task);
        try {
            task.run();
        }
        finally {
            PoemThread.endSession();
        }
    }

    public static Vector<SessionToken> openSessions() {
        Vector<SessionToken> open = new Vector<SessionToken>();
        Enumeration<SessionToken> e = null;
        e = sessionTokens.elements();
        while (e.hasMoreElements()) {
            SessionToken token = e.nextElement();
            if (token == null) continue;
            open.addElement(token);
        }
        return open;
    }

    static SessionToken _sessionToken() {
        if (Thread.currentThread().getName().length() != 1) {
            return null;
        }
        SessionToken context = sessionTokens.elementAt(Thread.currentThread().getName().charAt(0));
        if (context.thread == Thread.currentThread()) {
            return context;
        }
        return null;
    }

    public static SessionToken sessionToken() throws NotInSessionPoemException {
        SessionToken it = PoemThread._sessionToken();
        if (it == null) {
            throw new NotInSessionPoemException();
        }
        return it;
    }

    public static ToTidyList toTidy() throws NotInSessionPoemException {
        return PoemThread.sessionToken().toTidy();
    }

    public static PoemTransaction transaction() {
        return PoemThread.sessionToken().transaction;
    }

    public static boolean inSession() {
        return PoemThread._sessionToken() != null;
    }

    public static AccessToken accessToken() throws NotInSessionPoemException, NoAccessTokenPoemException {
        AccessToken it = PoemThread.sessionToken().accessToken;
        if (it == null) {
            throw new NoAccessTokenPoemException();
        }
        return it;
    }

    public static void setAccessToken(AccessToken token) throws NonRootSetAccessTokenPoemException {
        SessionToken context = PoemThread.sessionToken();
        AccessToken old = context.accessToken;
        if (old != AccessToken.root) {
            throw new NonRootSetAccessTokenPoemException(old);
        }
        context.accessToken = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withAccessToken(AccessToken token, PoemTask task) {
        SessionToken context = PoemThread.sessionToken();
        AccessToken old = context.accessToken;
        context.accessToken = token;
        try {
            task.run();
        }
        finally {
            context.accessToken = old;
        }
    }

    public static void assertHasCapability(Capability capability) throws NotInSessionPoemException, NoAccessTokenPoemException, AccessPoemException {
        AccessToken token = PoemThread.accessToken();
        if (!token.givesCapability(capability)) {
            throw new AccessPoemException(token, capability);
        }
    }

    public static Database database() throws NotInSessionPoemException {
        return PoemThread.transaction().getDatabase();
    }

    public static void writeDown() {
        PoemThread.transaction().writeDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit() {
        SessionToken token = PoemThread.sessionToken();
        try {
            token.transaction.commit();
        }
        finally {
            token.toTidy().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback() {
        SessionToken token = PoemThread.sessionToken();
        try {
            token.transaction.rollback();
        }
        finally {
            token.toTidy().close();
        }
    }
}

