/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.PoemType;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.SizedAtomPoemType;
import org.melati.poem.StringLengthValidationPoemException;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.util.StringUtils;

public class StringPoemType
extends SizedAtomPoemType<String> {
    public static final StringPoemType nullableInstance = new StringPoemType(true, -1);

    public StringPoemType(boolean nullable, int size) {
        super(12, "VARCHAR", nullable, size);
    }

    @Override
    protected void _assertValidRaw(Object raw) throws ValidationPoemException {
        if (raw != null) {
            if (!(raw instanceof String)) {
                throw new TypeMismatchPoemException(raw, this);
            }
            if (!StringPoemType.sizeGreaterEqual(this.getSize(), ((String)raw).length())) {
                throw new StringLengthValidationPoemException((PoemType)this, (String)raw);
            }
        }
    }

    @Override
    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        return rs.getString(col);
    }

    @Override
    protected void _setRaw(PreparedStatement ps, int col, Object string) throws SQLException {
        ps.setString(col, (String)string);
    }

    @Override
    protected String _rawOfString(String rawString) {
        return rawString;
    }

    @Override
    protected String _sqlDefinition(Dbms dbms) {
        try {
            return dbms.getStringSqlDefinition(this.getSize());
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return other instanceof StringPoemType && StringPoemType.sizeGreaterEqual(this.getSize(), ((StringPoemType)other).getSize());
    }

    @Override
    public String toString() {
        return (this.getNullable() ? "nullable " : "") + "String(" + this.getSize() + ")";
    }

    @Override
    public String toDsdType() {
        return "String";
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.STRING);
        columnInfo.setSize(this.getSize());
    }

    @Override
    protected String _quotedRaw(Object raw) {
        return StringUtils.quoted((String)raw, '\'');
    }
}

