/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AtomPoemType;
import org.melati.poem.ColumnInfo;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.TypeMismatchPoemException;

public class DoublePoemType
extends AtomPoemType {
    public static final DoublePoemType it = new DoublePoemType(true);

    public DoublePoemType(boolean nullable) {
        super(8, "DOUBLE PRECISION", nullable);
    }

    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof Double)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        ResultSet resultSet = rs;
        synchronized (resultSet) {
            double x = rs.getDouble(col);
            return rs.wasNull() ? null : new Double(x);
        }
    }

    protected void _setRaw(PreparedStatement ps, int col, Object real) throws SQLException {
        ps.setDouble(col, (Double)real);
    }

    protected Object _rawOfString(String rawString) throws ParsingPoemException {
        try {
            return new Double(rawString);
        }
        catch (NumberFormatException e) {
            throw new ParsingPoemException(this, rawString, e);
        }
    }

    protected boolean _canRepresent(SQLPoemType other) {
        return this.sqlTypeCode() == other.sqlTypeCode() && other instanceof DoublePoemType;
    }

    public String toDsdType() {
        return "Double";
    }

    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.DOUBLE);
    }
}

