/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Locale;
import org.melati.poem.util.StringUtils;

public class PoemLocale {
    public static final PoemLocale HERE = new PoemLocale(Locale.UK);
    private final Locale locale;
    private final DateFormatSymbols dateFormatSymbols;
    private final String[] months;
    private final String[] shortMonths;
    private final DateFormat[] dateFormats;
    private final DateFormat[] timestampFormats;

    public static PoemLocale fromLanguageTag(String tag) {
        String[] subtags = StringUtils.split(tag, '-');
        if (subtags.length > 0 && subtags[0].length() == 2) {
            Locale locale = null;
            locale = subtags.length > 1 && subtags[1].length() == 2 ? new Locale(subtags[0], subtags[1]) : new Locale(subtags[0], "");
            return new PoemLocale(locale);
        }
        return null;
    }

    public PoemLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
        this.dateFormatSymbols = new DateFormatSymbols(locale);
        this.months = this.dateFormatSymbols.getMonths();
        this.shortMonths = this.dateFormatSymbols.getShortMonths();
        this.dateFormats = new DateFormat[4];
        this.dateFormats[0] = DateFormat.getDateInstance(0, locale);
        this.dateFormats[1] = DateFormat.getDateInstance(1, locale);
        this.dateFormats[2] = DateFormat.getDateInstance(2, locale);
        this.dateFormats[3] = DateFormat.getDateInstance(3, locale);
        this.timestampFormats = new DateFormat[4];
        this.timestampFormats[0] = DateFormat.getDateTimeInstance(0, 0, locale);
        this.timestampFormats[1] = DateFormat.getDateTimeInstance(1, 1, locale);
        this.timestampFormats[2] = DateFormat.getDateTimeInstance(2, 2, locale);
        this.timestampFormats[3] = DateFormat.getDateTimeInstance(3, 3, locale);
    }

    public final Locale locale() {
        return this.locale;
    }

    public String monthName(int monthNum) {
        return this.months[monthNum - 1];
    }

    public String shortMonthName(int monthNum) {
        return this.shortMonths[monthNum - 1];
    }

    public DateFormat dateFormat(int style) {
        return this.dateFormats[style];
    }

    public DateFormat timestampFormat(int style) {
        return this.timestampFormats[style];
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PoemLocale) {
            return this.locale.equals(((PoemLocale)o).locale());
        }
        return false;
    }

    public String toString() {
        return this.locale.toString();
    }
}

