/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.melati.poem.Column;
import org.melati.poem.IntegrityFix;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.util.EmptyEnumeration;

public abstract class StandardIntegrityFix
implements IntegrityFix {
    private final Integer index;
    private final String name;
    public static final StandardIntegrityFix delete = new StandardIntegrityFix(0, "delete"){

        public Enumeration referencesTo(Persistent referee, Column column, Enumeration refs, Map referenceFixOfColumn) {
            while (refs.hasMoreElements()) {
                Persistent p = (Persistent)refs.nextElement();
                p.delete(referenceFixOfColumn);
            }
            return EmptyEnumeration.it;
        }
    };
    public static final StandardIntegrityFix clear = new StandardIntegrityFix(1, "clear"){

        public Enumeration referencesTo(Persistent referrer, Column column, Enumeration refs, Map referenceFixOfColumn) {
            while (refs.hasMoreElements()) {
                column.setRaw((Persistent)refs.nextElement(), null);
            }
            return EmptyEnumeration.it;
        }
    };
    public static final StandardIntegrityFix prevent = new StandardIntegrityFix(2, "prevent"){

        public Enumeration referencesTo(Persistent referrer, Column column, Enumeration refs, Map referenceFixOfColumn) {
            return refs;
        }
    };
    private static final StandardIntegrityFix[] fixes = new StandardIntegrityFix[]{delete, clear, prevent};
    private static final Hashtable fixOfName = new Hashtable();

    public String getName() {
        return this.name;
    }

    public Integer getIndex() {
        return this.index;
    }

    StandardIntegrityFix(int index, String name) {
        this.index = new Integer(index);
        this.name = name;
    }

    public abstract Enumeration referencesTo(Persistent var1, Column var2, Enumeration var3, Map var4);

    public static StandardIntegrityFix forIndex(int i) {
        return fixes[i];
    }

    public static int count() {
        return fixes.length;
    }

    public static StandardIntegrityFix named(String name) {
        StandardIntegrityFix it = (StandardIntegrityFix)fixOfName.get(name);
        if (it == null) {
            throw new NameUnrecognisedException(name);
        }
        return it;
    }

    public String toString() {
        return this.name + "/" + this.index;
    }

    static {
        for (int i = 0; i < fixes.length; ++i) {
            fixOfName.put(StandardIntegrityFix.fixes[i].name, fixes[i]);
        }
    }

    public static class NameUnrecognisedException
    extends PoemException {
        private static final long serialVersionUID = 1L;
        public String name;

        public NameUnrecognisedException(String name) {
            this.name = name;
        }

        public String getMessage() {
            return "No integrity fix found which goes by the name `" + this.name + "'";
        }
    }
}

