/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AtomPoemType;
import org.melati.poem.ColumnInfo;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.TypeMismatchPoemException;

public class DatePoemType
extends AtomPoemType<Date> {
    public DatePoemType(boolean nullable) {
        super(91, "DATE", nullable);
    }

    public DatePoemType(int sqlTypeCode, String sqlTypeName, boolean nullable) {
        super(sqlTypeCode, sqlTypeName, nullable);
    }

    @Override
    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof Date)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    @Override
    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        return rs.getDate(col);
    }

    @Override
    protected void _setRaw(PreparedStatement ps, int col, Object raw) throws SQLException {
        ps.setDate(col, (Date)raw);
    }

    @Override
    protected Date _rawOfString(String raw) {
        if (raw.length() == 8) {
            return Date.valueOf(raw.substring(4, 8) + "-" + raw.substring(2, 4) + "-" + raw.substring(0, 2));
        }
        return Date.valueOf(raw);
    }

    @Override
    protected String _stringOfCooked(Object cooked, PoemLocale locale, int style) {
        return locale.dateFormat(style).format((Date)cooked);
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return other instanceof DatePoemType;
    }

    @Override
    public String toDsdType() {
        return "Date";
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.DATE);
    }
}

