/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Hashtable;
import org.melati.poem.PoemException;

public final class DisplayLevel {
    public final Integer index;
    private final String name;
    public static final DisplayLevel primary;
    public static final DisplayLevel summary;
    public static final DisplayLevel record;
    public static final DisplayLevel detail;
    public static final DisplayLevel never;
    private static int n;
    private static final DisplayLevel[] displayLevels;
    private static final Hashtable levelOfName;

    private DisplayLevel(int index, String name) {
        this.index = new Integer(index);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Integer getIndex() {
        return this.index;
    }

    public static DisplayLevel forIndex(int index) {
        return displayLevels[index];
    }

    public static int count() {
        return displayLevels.length;
    }

    public static DisplayLevel named(String name) {
        DisplayLevel it = (DisplayLevel)levelOfName.get(name);
        if (it == null) {
            throw new NameUnrecognisedException(name);
        }
        return it;
    }

    public String toString() {
        return this.name + "/" + this.index;
    }

    static {
        n = 0;
        displayLevels = new DisplayLevel[]{primary = new DisplayLevel(n++, "primary"), summary = new DisplayLevel(n++, "summary"), record = new DisplayLevel(n++, "record"), detail = new DisplayLevel(n++, "detail"), never = new DisplayLevel(n++, "never")};
        levelOfName = new Hashtable();
        for (int i = 0; i < displayLevels.length; ++i) {
            levelOfName.put(DisplayLevel.displayLevels[i].name, displayLevels[i]);
        }
    }

    public static class NameUnrecognisedException
    extends PoemException {
        private static final long serialVersionUID = 1L;
        public String name;

        public NameUnrecognisedException(String name) {
            this.name = name;
        }

        @Override
        public String getMessage() {
            return "No display level found which goes by the name `" + this.name + "'";
        }
    }
}

