/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util;

public final class StringUtils {
    private static String allowableChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz0123456789";
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String[] split(String s, char c) {
        int n = 0;
        int i = s.indexOf(c);
        while (i >= 0) {
            ++n;
            i = s.indexOf(c, i + 1);
        }
        String[] them = new String[n + 1];
        int i2 = 0;
        int m = 0;
        while (true) {
            int j;
            if ((j = s.indexOf(c, i2)) == -1) break;
            them[m] = s.substring(i2, j);
            i2 = j + 1;
            ++m;
        }
        them[m] = s.substring(i2);
        return them;
    }

    public static void appendEscaped(StringBuffer b, String s, char character) {
        StringUtils.appendEscaped(b, s, character, '\\');
    }

    public static void appendEscaped(StringBuffer b, String s, char character, char escapeChar) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c != escapeChar && c != character) continue;
            for (int j = 0; j < i; ++j) {
                b.append(s.charAt(j));
            }
            b.append(escapeChar);
            b.append(c);
            ++i;
            while (i < l) {
                c = s.charAt(i);
                if (c == escapeChar || c == character) {
                    b.append(escapeChar);
                }
                b.append(c);
                ++i;
            }
            return;
        }
        b.append(s);
    }

    public static void appendQuoted(StringBuffer b, String s, char q) {
        b.append(q);
        StringUtils.appendEscaped(b, s, q);
        b.append(q);
    }

    public static String quoted(String i, char q) {
        StringBuffer b = new StringBuffer();
        StringUtils.appendQuoted(b, i, q);
        return b.toString();
    }

    public static String capitalised(String name) {
        char[] suffix = name.toCharArray();
        suffix[0] = Character.toUpperCase(suffix[0]);
        return new String(suffix);
    }

    public static String uncapitalised(String name) {
        char[] suffix = name.toCharArray();
        suffix[0] = Character.toLowerCase(suffix[0]);
        return new String(suffix);
    }

    public static String tr(String s, String from, String to) {
        StringBuffer sNew = null;
        for (int i = 0; i < s.length(); ++i) {
            int t = from.indexOf(s.charAt(i));
            if (t == -1) continue;
            if (sNew == null) {
                sNew = new StringBuffer(s);
            }
            sNew.setCharAt(i, to.charAt(t));
        }
        return sNew == null ? s : sNew.toString();
    }

    public static String tr(String s, char from, char to) {
        StringBuffer sNew = null;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != from) continue;
            if (sNew == null) {
                sNew = new StringBuffer(s);
            }
            sNew.setCharAt(i, to);
        }
        return sNew == null ? s : sNew.toString();
    }

    public static String concatenated(String sep, String[] xs) {
        if (sep == null) {
            sep = "";
        }
        if (xs.length == 0) {
            return "";
        }
        int l = sep.length() * (xs.length - 1) + xs[0].length();
        for (int i = 1; i < xs.length; ++i) {
            l += xs[i].length();
        }
        StringBuffer c = new StringBuffer(l);
        c.append(xs[0]);
        for (int i = 1; i < xs.length; ++i) {
            c.append(sep);
            c.append(xs[i]);
        }
        return c.toString();
    }

    public static String randomString(int length) {
        String result = "";
        int j = allowableChars.length();
        for (int a = 0; a < length; ++a) {
            int index = new Double(Math.random() * (double)j).intValue();
            result = result + allowableChars.charAt(index);
        }
        return result;
    }

    public static String nulled(String s) {
        if (s != null && s.equals("")) {
            return null;
        }
        return s;
    }

    public static String unNulled(String in) {
        if (in == null) {
            return "";
        }
        return in;
    }

    public static String hexEncoding(byte[] bytes) {
        StringBuffer it = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            it.append(hexDigits[b >> 4 & 0xF]);
            it.append(hexDigits[b & 0xF]);
        }
        return it.toString();
    }

    public static byte hexDecoding(char c) {
        if ('0' <= c && c <= '9') {
            return (byte)(c - 48);
        }
        if ('A' <= c && c <= 'F') {
            return (byte)(10 + c - 65);
        }
        if ('a' <= c && c <= 'f') {
            return (byte)(10 + c - 97);
        }
        throw new IllegalArgumentException("Invalid hex digit in string");
    }

    public static byte[] hexDecoding(String digits) {
        int l = digits.length() / 2;
        if (l * 2 != digits.length()) {
            throw new IllegalArgumentException("Hex string has odd number of digits");
        }
        byte[] it = new byte[l];
        for (int i = 0; i < l; ++i) {
            it[i] = (byte)(StringUtils.hexDecoding(digits.charAt(i * 2)) << 4 | StringUtils.hexDecoding(digits.charAt(i * 2 + 1)));
        }
        return it;
    }

    public static boolean isQuoted(String in) {
        if (in == null) {
            return false;
        }
        if (in.length() < 2) {
            return false;
        }
        return !(!in.startsWith("'") && !in.startsWith("\"") || !in.endsWith("'") && !in.endsWith("\""));
    }
}

