/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.IndexPoemType;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.PoemLocale;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Table;
import org.melati.poem.TableMismatchPoemException;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.util.StringUtils;

public class ReferencePoemType
extends IndexPoemType {
    private Table targetTable;

    public ReferencePoemType(Table targetTable, boolean nullable) {
        super(nullable);
        if (targetTable == null) {
            throw new NullPointerException();
        }
        this.targetTable = targetTable;
    }

    public Table targetTable() {
        return this.targetTable;
    }

    protected Enumeration _possibleRaws() {
        return this.targetTable.troidSelection(null, null, false);
    }

    protected void _assertValidCooked(Object cooked) throws ValidationPoemException {
        if (!(cooked instanceof Persistent)) {
            throw new TypeMismatchPoemException(cooked, this);
        }
        Persistent persistent = (Persistent)cooked;
        if (persistent.getTable() != this.targetTable) {
            throw new ValidationPoemException(this, persistent, new TableMismatchPoemException(persistent, this.targetTable));
        }
    }

    protected Object _cookedOfRaw(Object raw) throws NoSuchRowPoemException {
        return this.targetTable.getObject((Integer)raw);
    }

    protected Object _rawOfCooked(Object cooked) {
        return ((Persistent)cooked).troid();
    }

    protected String _stringOfCooked(Object cooked, PoemLocale locale, int style) throws PoemException {
        return ((Persistent)cooked).displayString(locale, style);
    }

    protected boolean _canRepresent(SQLPoemType other) {
        return other instanceof ReferencePoemType && ((ReferencePoemType)other).targetTable == this.targetTable;
    }

    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactoryCode(this.targetTable.tableInfoID());
    }

    public String toString() {
        return "reference to " + this.targetTable.getName() + " (" + super.toString() + ")";
    }

    public String toDsdType() {
        return StringUtils.capitalised(this.targetTable.getName());
    }
}

