/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import org.melati.poem.ColumnInfo;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.ExtraColumn;
import org.melati.poem.JdbcTable;
import org.melati.poem.NoSuchTablePoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.Searchability;
import org.melati.poem.Table;
import org.melati.poem.TableCategoryTable;
import org.melati.poem.TableInfo;
import org.melati.poem.TroidPoemType;
import org.melati.poem.util.ClassUtils;
import org.melati.poem.util.StringUtils;

public final class TableFactory {
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    private TableFactory() {
    }

    public static Table fromInstance(Database db, Object pojo) {
        return TableFactory.fromClass(db, pojo.getClass());
    }

    public static Table fromClass(Database db, Class clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Cannot create a Table for a primitive type: " + clazz.getName());
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Cannot create a Table for an interface: " + clazz.getName());
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException("Cannot create a Table for a non public type: " + clazz.getName());
        }
        if (clazz.isArray() && clazz != [B.class) {
            throw new IllegalArgumentException("Cannot create a Table for an array: " + clazz.getName());
        }
        String name = clazz.getName();
        String simpleName = name.substring(name.lastIndexOf(46) + 1);
        try {
            return db.getTable(simpleName);
        }
        catch (NoSuchTablePoemException e) {
            System.err.println("Creating a table for : " + name);
            TableInfo tableInfo = (TableInfo)db.getTableInfoTable().newPersistent();
            tableInfo.setName(simpleName);
            tableInfo.setDisplayname(simpleName + " introspected table");
            tableInfo.setDisplayorder(13);
            tableInfo.setSeqcached(Boolean.FALSE);
            tableInfo.setCategory(TableCategoryTable.NORMAL);
            tableInfo.setCachelimit(555);
            tableInfo.makePersistent();
            JdbcTable table = new JdbcTable(db, simpleName, DefinitionSource.runtime);
            String troidName = "id";
            if (ClassUtils.getNoArgMethod(clazz, "getId") != null && !Persistent.class.isAssignableFrom(clazz)) {
                troidName = "poemId";
            }
            table.defineColumn(new ExtraColumn(table, troidName, TroidPoemType.it, DefinitionSource.runtime, table.getNextExtrasIndex()));
            table.setTableInfo(tableInfo);
            table.unifyWithColumnInfo();
            table.unifyWithDB(null);
            PoemThread.commit();
            db.defineTable(table);
            Hashtable<String, Prop> props = new Hashtable<String, Prop>();
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Prop p;
                String propName;
                if (!Modifier.isPublic(methods[i].getModifiers())) continue;
                if (!(!methods[i].getName().startsWith("set") || methods[i].getName().equals("set") || !Character.isUpperCase(methods[i].getName().toCharArray()[3]) || methods[i].getParameterTypes().length != 1 || methods[i].getParameterTypes()[0] != (array$B == null ? TableFactory.class$("[B") : array$B) && methods[i].getParameterTypes()[0].isArray() || methods[i].getParameterTypes()[0].isInterface() || (class$java$util$Collection == null ? TableFactory.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(methods[i].getParameterTypes()[0]) || (class$java$util$Map == null ? TableFactory.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(methods[i].getParameterTypes()[0]))) {
                    propName = methods[i].getName().substring(3);
                    propName = StringUtils.uncapitalised(propName);
                    p = (Prop)props.get(propName);
                    Class<?> setClass = methods[i].getParameterTypes()[0];
                    if (p == null) {
                        p = new Prop(propName);
                        p.setSet(setClass);
                    } else if (p.getGot() != null) {
                        if (p.getGot() == setClass) {
                            p.setSet(setClass);
                        }
                    } else {
                        p.setSet(setClass);
                    }
                    props.put(propName, p);
                }
                if (methods[i].getParameterTypes().length != 0 || methods[i].getReturnType().isInterface() || methods[i].getReturnType() != (array$B == null ? TableFactory.class$("[B") : array$B) && methods[i].getReturnType().isArray() || (class$java$util$Collection == null ? TableFactory.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(methods[i].getReturnType()) || (class$java$util$Map == null ? TableFactory.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(methods[i].getReturnType())) continue;
                propName = null;
                if (methods[i].getName().startsWith("get") && Character.isUpperCase(methods[i].getName().toCharArray()[3])) {
                    propName = methods[i].getName().substring(3);
                } else if (methods[i].getName().startsWith("is") && Character.isUpperCase(methods[i].getName().toCharArray()[2])) {
                    propName = methods[i].getName().substring(2);
                }
                if (propName == null) continue;
                propName = StringUtils.uncapitalised(propName);
                p = (Prop)props.get(propName);
                Class<?> gotClass = methods[i].getReturnType();
                if (p == null) {
                    p = new Prop(propName);
                    p.setGot(gotClass);
                } else {
                    p.setGot(gotClass);
                }
                props.put(propName, p);
            }
            Enumeration propsEn = props.elements();
            while (propsEn.hasMoreElements()) {
                Prop p = (Prop)propsEn.nextElement();
                if (p.getGot() == null || p.getGot() != p.getSet()) continue;
                TableFactory.addColumn(table, p.getName(), p.getGot(), p.getGot() == p.getSet());
            }
            return table;
        }
    }

    private static void addColumn(Table table, String name, Class fieldClass, boolean hasSetter) {
        ColumnInfo columnInfo = (ColumnInfo)table.getDatabase().getColumnInfoTable().newPersistent();
        columnInfo.setTableinfo(table.getInfo());
        columnInfo.setName(name);
        columnInfo.setDisplayname(name);
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("An introspected member");
        columnInfo.setUsercreateable(hasSetter);
        columnInfo.setUsereditable(hasSetter);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(true);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        if (fieldClass == Boolean.class) {
            columnInfo.setTypefactory(PoemTypeFactory.BOOLEAN);
            columnInfo.setSize(1);
            columnInfo.setWidth(10);
        } else if (fieldClass == Boolean.TYPE) {
            columnInfo.setTypefactory(PoemTypeFactory.BOOLEAN);
            columnInfo.setSize(1);
            columnInfo.setWidth(10);
        } else if (fieldClass == Integer.class) {
            columnInfo.setTypefactory(PoemTypeFactory.INTEGER);
        } else if (fieldClass == Integer.TYPE) {
            columnInfo.setTypefactory(PoemTypeFactory.INTEGER);
        } else if (fieldClass == Double.class) {
            columnInfo.setTypefactory(PoemTypeFactory.DOUBLE);
        } else if (fieldClass == Double.TYPE) {
            columnInfo.setTypefactory(PoemTypeFactory.DOUBLE);
        } else if (fieldClass == Long.class) {
            columnInfo.setTypefactory(PoemTypeFactory.LONG);
        } else if (fieldClass == Long.TYPE) {
            columnInfo.setTypefactory(PoemTypeFactory.LONG);
        } else if (fieldClass == BigDecimal.class) {
            columnInfo.setTypefactory(PoemTypeFactory.BIGDECIMAL);
            columnInfo.setPrecision(22);
            columnInfo.setScale(2);
        } else if (fieldClass == String.class) {
            columnInfo.setTypefactory(PoemTypeFactory.STRING);
            columnInfo.setSize(-1);
        } else if (fieldClass == Date.class) {
            columnInfo.setTypefactory(PoemTypeFactory.DATE);
        } else if (fieldClass == Timestamp.class) {
            columnInfo.setTypefactory(PoemTypeFactory.TIMESTAMP);
        } else if (fieldClass == [B.class) {
            columnInfo.setTypefactory(PoemTypeFactory.BINARY);
        } else {
            Table referredTable = TableFactory.fromClass(table.getDatabase(), fieldClass);
            columnInfo.setTypefactory(PoemTypeFactory.forCode(table.getDatabase(), referredTable.getInfo().troid()));
        }
        columnInfo.makePersistent();
        table.addColumnAndCommit(columnInfo);
    }

    static final class Prop {
        String name = null;
        Class set = null;
        Class got = null;

        Prop(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Class getGot() {
            return this.got;
        }

        public void setGot(Class got) {
            this.got = got;
        }

        public Class getSet() {
            return this.set;
        }

        public void setSet(Class set) {
            this.set = set;
        }
    }
}

