/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util;

import java.util.Enumeration;
import java.util.Vector;
import org.melati.poem.util.SkipEnumeration;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static int skip(Enumeration e, int n) {
        int c;
        if (e instanceof SkipEnumeration) {
            SkipEnumeration s = (SkipEnumeration)e;
            for (c = 0; c < n && s.hasMoreElements(); ++c) {
                s.skip();
            }
        } else {
            while (c < n && e.hasMoreElements()) {
                e.nextElement();
                ++c;
            }
        }
        return c;
    }

    public static Vector initial(Enumeration e, int n) {
        Vector v = new Vector(n);
        while (n > 0 && e.hasMoreElements()) {
            v.addElement(e.nextElement());
            --n;
        }
        return v;
    }

    public static Enumeration join(Enumeration a, Enumeration b) {
        Vector aVector = EnumUtils.vectorOf(a);
        while (b.hasMoreElements()) {
            aVector.addElement(b.nextElement());
        }
        return aVector.elements();
    }

    public static Vector vectorOf(Enumeration e, int roughSize) {
        Vector v = new Vector(roughSize);
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return v;
    }

    public static Vector vectorOf(Enumeration e) {
        return EnumUtils.vectorOf(e, 20);
    }

    public static String concatenated(String sep, Enumeration e) {
        StringBuffer b = new StringBuffer();
        if (e.hasMoreElements()) {
            b.append(String.valueOf(e.nextElement()));
        }
        while (e.hasMoreElements()) {
            b.append(sep);
            b.append(String.valueOf(e.nextElement()));
        }
        return b.toString();
    }

    public static boolean contains(Enumeration e, Object o) {
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(o)) continue;
            return true;
        }
        return false;
    }
}

