/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.melati.poem.util.SkipEnumeration;

public class LimitedEnumeration
implements SkipEnumeration {
    private Enumeration base;
    private int limit;
    private int seen = 0;

    public LimitedEnumeration(Enumeration base, int limit) {
        this.base = base;
        this.limit = limit;
    }

    public synchronized boolean hasMoreElements() {
        return this.seen < this.limit && this.base.hasMoreElements();
    }

    public synchronized Object nextElement() throws NoSuchElementException {
        if (this.seen >= this.limit) {
            throw new NoSuchElementException();
        }
        Object it = this.base.nextElement();
        ++this.seen;
        return it;
    }

    public synchronized void skip() throws NoSuchElementException {
        if (this.seen >= this.limit) {
            throw new NoSuchElementException();
        }
        if (this.base instanceof SkipEnumeration) {
            ((SkipEnumeration)this.base).skip();
        } else {
            this.base.nextElement();
        }
        ++this.seen;
    }
}

