/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AtomPoemType;
import org.melati.poem.BooleanPossibleRawEnumeration;
import org.melati.poem.ColumnInfo;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.TypeMismatchPoemException;

public class BooleanPoemType
extends AtomPoemType {
    public BooleanPoemType(boolean nullable) {
        super(-7, "BOOLEAN", nullable);
    }

    protected Enumeration _possibleRaws() {
        return new BooleanPossibleRawEnumeration();
    }

    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof Boolean)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        ResultSet resultSet = rs;
        synchronized (resultSet) {
            boolean b = rs.getBoolean(col);
            return rs.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void _setRaw(PreparedStatement ps, int col, Object bool) throws SQLException {
        ps.setBoolean(col, (Boolean)bool);
    }

    protected Object _rawOfString(String rawString) throws ParsingPoemException {
        if ((rawString = rawString.trim()).length() == 1) {
            switch (rawString.charAt(0)) {
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    return Boolean.TRUE;
                }
                case '0': 
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    return Boolean.FALSE;
                }
            }
            throw new ParsingPoemException(this, rawString);
        }
        if (rawString.regionMatches(0, "true", 0, 4) || rawString.regionMatches(0, "yes", 0, 3)) {
            return Boolean.TRUE;
        }
        if (rawString.regionMatches(0, "false", 0, 5) || rawString.regionMatches(0, "no", 0, 2)) {
            return Boolean.FALSE;
        }
        throw new ParsingPoemException(this, rawString);
    }

    protected boolean _canRepresent(SQLPoemType other) {
        return other instanceof BooleanPoemType;
    }

    public String toDsdType() {
        return "Boolean";
    }

    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.BOOLEAN);
    }
}

