/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AppBugPoemException;
import org.melati.poem.CachedSelection;
import org.melati.poem.ColumnInfo;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DeletedPoemType;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.FieldAttributes;
import org.melati.poem.FieldContentsPoemException;
import org.melati.poem.IndexUniquenessPoemException;
import org.melati.poem.Initialiser;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.IntegrityFix;
import org.melati.poem.NormalPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemType;
import org.melati.poem.PreparedStatementFactory;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.ResultSetEnumeration;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.Searchability;
import org.melati.poem.SessionToken;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.Table;
import org.melati.poem.TroidPoemType;
import org.melati.poem.TypeDefinitionMismatchException;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.util.EmptyEnumeration;
import org.melati.poem.util.StringUtils;

public abstract class Column
implements FieldAttributes {
    private Table table = null;
    private String name;
    private String quotedName;
    private SQLPoemType type;
    private DefinitionSource definitionSource;
    private ColumnInfo info = null;
    private PreparedStatementFactory selectionWhereEq = null;

    public Column(Table table, String name, SQLPoemType type, DefinitionSource definitionSource) {
        this.table = table;
        this.name = name;
        this.quotedName = table.getDatabase().quotedName(name);
        this.type = type;
        this.definitionSource = definitionSource;
    }

    Dbms dbms() {
        return this.getDatabase().getDbms();
    }

    void unifyType(SQLPoemType storeType, DefinitionSource source) {
        PoemType unified = this.dbms().canRepresent(storeType, this.type);
        if (unified == null || !(unified instanceof SQLPoemType)) {
            throw new TypeDefinitionMismatchException(this, storeType, source);
        }
        this.type = (SQLPoemType)unified;
    }

    void assertMatches(ResultSet colDesc) throws SQLException, TypeDefinitionMismatchException {
        SQLPoemType dbType = this.getDatabase().defaultPoemTypeOfColumnMetaData(colDesc);
        if (this.dbms().canRepresent(dbType, this.type) == null) {
            throw new TypeDefinitionMismatchException(this, dbType, DefinitionSource.sqlMetaData);
        }
    }

    void setColumnInfo(ColumnInfo columnInfo) {
        try {
            this.unifyType(columnInfo.getType(), DefinitionSource.infoTables);
            columnInfo.setColumn(this);
            if (columnInfo.getDisplaylevel() == DisplayLevel.primary) {
                this.table.setDisplayColumn(this);
            }
            if (columnInfo.getSearchability() == Searchability.primary) {
                this.table.setSearchColumn(this);
            }
            this.info = columnInfo;
            this.table.notifyColumnInfo(this.info);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionPoemException(e, "Setting column info for " + this.name + " to " + columnInfo);
        }
    }

    protected DisplayLevel defaultDisplayLevel() {
        return DisplayLevel.summary;
    }

    protected Searchability defaultSearchability() {
        return Searchability.yes;
    }

    protected Integer defaultDisplayOrderPriority() {
        return null;
    }

    protected boolean defaultSortDescending() {
        return false;
    }

    protected String defaultDisplayName() {
        return StringUtils.capitalised(this.getName());
    }

    protected int defaultDisplayOrder() {
        return 100;
    }

    protected String defaultDescription() {
        return null;
    }

    protected boolean defaultUserEditable() {
        return true;
    }

    protected boolean defaultUserCreateable() {
        return true;
    }

    protected boolean defaultIndexed() {
        return this.isTroidColumn();
    }

    protected boolean defaultUnique() {
        return this.isTroidColumn();
    }

    protected StandardIntegrityFix defaultIntegrityFix() {
        return StandardIntegrityFix.prevent;
    }

    protected int defaultWidth() {
        return 20;
    }

    protected int defaultHeight() {
        return 1;
    }

    protected int defaultPrecision() {
        return 22;
    }

    protected int defaultScale() {
        return 2;
    }

    protected String defaultRenderinfo() {
        return null;
    }

    void createColumnInfo() throws PoemException {
        if (this.info == null) {
            this.info = (ColumnInfo)this.getDatabase().getColumnInfoTable().create(new Initialiser(){

                public void init(Persistent g) throws AccessPoemException {
                    ColumnInfo i = (ColumnInfo)g;
                    i.setName(Column.this.getName());
                    i.setDisplayname(Column.this.defaultDisplayName());
                    i.setDisplayorder(Column.this.defaultDisplayOrder());
                    i.setDescription(Column.this.defaultDescription());
                    i.setDisplaylevel(Column.this.defaultDisplayLevel());
                    i.setSearchability(Column.this.defaultSearchability());
                    i.setSortdescending(Column.this.defaultSortDescending());
                    i.setDisplayorderpriority(Column.this.defaultDisplayOrderPriority());
                    i.setTableinfoTroid(Column.this.table.tableInfoID());
                    i.setUsereditable(Column.this.defaultUserEditable());
                    i.setUsercreateable(Column.this.defaultUserCreateable());
                    i.setIndexed(Column.this.defaultIndexed());
                    i.setUnique(Column.this.defaultUnique());
                    i.setWidth(Column.this.defaultWidth());
                    i.setHeight(Column.this.defaultHeight());
                    i.setRenderinfo(Column.this.defaultRenderinfo());
                    i.setIntegrityfix(Column.this.defaultIntegrityFix());
                    i.setPrecision(Column.this.defaultPrecision());
                    i.setScale(Column.this.defaultScale());
                    Column.this.getType().saveColumnInfo(i);
                }
            });
            if (this.defaultDisplayLevel() == DisplayLevel.primary) {
                this.table.setDisplayColumn(this);
            }
            if (this.defaultSearchability() == Searchability.primary) {
                this.table.setSearchColumn(this);
            }
        }
    }

    void unifyWithIndex(String indexName, ResultSet index) throws SQLException, IndexUniquenessPoemException {
        boolean indexUnique;
        boolean bl = indexUnique = !index.getBoolean("NON_UNIQUE");
        if (indexUnique != this.getUnique()) {
            throw new IndexUniquenessPoemException(this, indexName, this.getUnique());
        }
    }

    public final Database getDatabase() {
        return this.getTable().getDatabase();
    }

    public final Table getTable() {
        return this.table;
    }

    final void setTable(Table table) {
        this.table = table;
    }

    public final String getName() {
        return this.name;
    }

    public final String quotedName() {
        return this.quotedName;
    }

    public final String fullQuotedName() {
        return this.table.quotedName() + "." + this.quotedName;
    }

    public final String getDisplayName() {
        return this.info.getDisplayname();
    }

    public final String getDescription() {
        return this.info.getDescription();
    }

    final Integer columnInfoID() {
        return this.info == null ? null : this.info.troid();
    }

    public final ColumnInfo getColumnInfo() {
        return this.info;
    }

    public DisplayLevel getDisplayLevel() {
        return this.info == null ? this.defaultDisplayLevel() : this.info.getDisplaylevel();
    }

    public void setDisplayLevel(DisplayLevel level) {
        if (this.info != null) {
            this.info.setDisplaylevel(level);
        }
    }

    public Searchability getSearchability() {
        return this.info == null ? this.defaultSearchability() : this.info.getSearchability();
    }

    public void setSearchability(Searchability searchability) {
        if (this.info != null) {
            this.info.setSearchability(searchability);
        }
    }

    public final boolean getUserEditable() {
        return !this.isTroidColumn() && (this.info == null || this.info.getUsereditable() != false);
    }

    public final boolean getUserCreateable() {
        return !this.isTroidColumn() && (this.info == null || this.info.getUsercreateable() != false);
    }

    public final SQLPoemType getSQLType() {
        return this.type;
    }

    public final PoemType getType() {
        return this.type;
    }

    public final boolean isTroidColumn() {
        return this.getType() instanceof TroidPoemType;
    }

    public final boolean isDeletedColumn() {
        return this.getType() instanceof DeletedPoemType;
    }

    public final boolean getIndexed() {
        return this.getUnique() || this.info.getIndexed() != false;
    }

    public final boolean getUnique() {
        return this.isTroidColumn() || this.info.getUnique() != false;
    }

    public IntegrityFix getIntegrityFix() {
        StandardIntegrityFix it = this.info.getIntegrityfix();
        return it == null ? this.defaultIntegrityFix() : it;
    }

    public void setIntegrityFix(StandardIntegrityFix fix) {
        this.info.setIntegrityfix(fix);
    }

    public final String getRenderInfo() {
        return this.info.getRenderinfo();
    }

    public final int getWidth() {
        return this.info.getWidth();
    }

    public final int getHeight() {
        return this.info.getHeight();
    }

    public final Integer getDisplayOrderPriority() {
        return this.info == null ? null : this.info.getDisplayorderpriority();
    }

    public final boolean getSortDescending() {
        return this.info.getSortdescending() == null ? false : this.info.getSortdescending();
    }

    public String toString() {
        return this.table.getName() + "." + this.name + ": " + this.getType().toString() + " (from " + this.definitionSource + ")";
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream ps) {
        ps.println(this.toString());
    }

    public String eqClause(Object raw) {
        return this.fullQuotedName() + (raw == null ? " IS NULL" : " = " + this.type.quotedRaw(raw));
    }

    private PreparedStatementFactory statementWhereEq() {
        if (this.selectionWhereEq == null) {
            this.selectionWhereEq = new PreparedStatementFactory(this.getDatabase(), this.getTable().selectionSQL(this.getTable().quotedName(), this.fullQuotedName() + " = " + this.dbms().preparedStatementPlaceholder(this.getType()), null, false, true));
        }
        return this.selectionWhereEq;
    }

    ResultSet resultSetWhereEq(Object raw) {
        SessionToken token = PoemThread.sessionToken();
        PreparedStatement ps = this.statementWhereEq().preparedStatement(token.transaction);
        this.type.setRaw(ps, 1, raw);
        return this.statementWhereEq().resultSet(token, ps);
    }

    public Enumeration selectionWhereEq(Object raw) {
        return new ResultSetEnumeration(this.resultSetWhereEq(raw)){

            public Object mapped(ResultSet rs) throws SQLException {
                return Column.this.getTable().getObject(rs.getInt(1));
            }
        };
    }

    public Persistent firstWhereEq(Object raw) {
        Enumeration them = this.selectionWhereEq(raw);
        return them.hasMoreElements() ? (Persistent)them.nextElement() : null;
    }

    public CachedSelection cachedSelectionWhereEq(Object raw) {
        return new CachedSelection(this.getTable(), this.eqClause(raw), null);
    }

    public abstract Object getRaw(Persistent var1) throws AccessPoemException;

    public abstract Object getRaw_unsafe(Persistent var1);

    public abstract void setRaw(Persistent var1, Object var2) throws AccessPoemException, ValidationPoemException;

    public abstract void setRaw_unsafe(Persistent var1, Object var2);

    public abstract Object getCooked(Persistent var1) throws AccessPoemException, PoemException;

    public abstract void setCooked(Persistent var1, Object var2) throws AccessPoemException, ValidationPoemException;

    void load_unsafe(ResultSet rs, int rsCol, Persistent g) throws LoadException {
        try {
            this.setRaw_unsafe(g, this.type.getRaw(rs, rsCol));
        }
        catch (Exception e) {
            throw new LoadException(this, e);
        }
    }

    void save_unsafe(Persistent g, PreparedStatement ps, int psCol) {
        try {
            this.type.setRaw(ps, psCol, this.getRaw_unsafe(g));
        }
        catch (Exception e) {
            throw new FieldContentsPoemException(this, e);
        }
    }

    public abstract Field asField(Persistent var1);

    public Field asEmptyField() {
        return new Field((Object)null, (FieldAttributes)this);
    }

    public void setRawString(Persistent g, String rawString) {
        Object raw;
        try {
            raw = this.getType().rawOfString(rawString);
        }
        catch (Exception e) {
            throw new SettingException(g, this, e);
        }
        this.setRaw(g, raw);
    }

    public Enumeration referencesTo(Persistent object) {
        return this.getType() instanceof ReferencePoemType && ((ReferencePoemType)this.getType()).targetTable() == object.getTable() ? this.selectionWhereEq(object.troid()) : EmptyEnumeration.it;
    }

    public Persistent ensure(Persistent orCreate) {
        Persistent there = this.firstWhereEq(this.getRaw_unsafe(orCreate));
        if (there == null) {
            this.getTable().create(orCreate);
            return orCreate;
        }
        return there;
    }

    public int firstFree(String whereClause) {
        if (!(this.getType() instanceof IntegerPoemType)) {
            throw new AppBugPoemException("firstFree called on a non Integer column");
        }
        this.getTable().readLock();
        String querySelection = this.quotedName + " + 1 " + "FROM " + this.getTable().quotedName() + " AS t1 " + "WHERE " + (whereClause == null ? "" : "(t1." + whereClause + ") AND ") + "NOT EXISTS (" + "SELECT * FROM " + this.getTable().quotedName() + " AS t2 " + "WHERE " + (whereClause == null ? "" : "(t2." + whereClause + ") AND ") + "t2." + this.quotedName + " = t1." + this.quotedName + " + 1) ";
        String query = this.getDatabase().getDbms().selectLimit(querySelection, 1);
        ResultSet results = this.getDatabase().sqlQuery(query);
        try {
            if (results.next()) {
                return results.getInt(1);
            }
            return 0;
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    public static class SettingException
    extends NormalPoemException {
        private static final long serialVersionUID = 1L;
        public Persistent persistent;
        public Column column;
        public String columnDesc;

        public SettingException(Persistent persistent, Column column, Exception trouble) {
            super(trouble);
            this.persistent = persistent;
            this.column = column;
            this.columnDesc = "field `" + column.getDisplayName() + "' in object `" + persistent.displayString() + "' of type `" + column.getTable().getDisplayName() + "'";
        }

        public String getMessage() {
            return "Unable to set " + this.columnDesc + "\n" + this.subException;
        }
    }

    public static class LoadException
    extends UnexpectedExceptionPoemException {
        private static final long serialVersionUID = 1L;
        private Column column;

        public LoadException(Column column, Exception problem) {
            super(problem);
            this.column = column;
        }

        public String getMessage() {
            return "An unexpected problem arose loading " + this.column + " from the " + "database:\n" + this.subException;
        }

        protected Column getColumn() {
            return this.column;
        }
    }
}

